/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;

public class Variant {
    private Locale language;
    private MediaType mediaType;
    private String encoding;

    public Variant(MediaType mediaType, Locale locale, String string) {
        if (mediaType == null && locale == null && string == null) {
            throw new IllegalArgumentException("mediaType, language, encoding all null");
        }
        this.encoding = string;
        this.language = locale;
        this.mediaType = mediaType;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static VariantListBuilder mediaTypes(MediaType ... mediaTypeArray) {
        VariantListBuilder variantListBuilder = VariantListBuilder.newInstance();
        variantListBuilder.mediaTypes(mediaTypeArray);
        return variantListBuilder;
    }

    public static VariantListBuilder languages(Locale ... localeArray) {
        VariantListBuilder variantListBuilder = VariantListBuilder.newInstance();
        variantListBuilder.languages(localeArray);
        return variantListBuilder;
    }

    public static VariantListBuilder encodings(String ... stringArray) {
        VariantListBuilder variantListBuilder = VariantListBuilder.newInstance();
        variantListBuilder.encodings(stringArray);
        return variantListBuilder;
    }

    public int hashCode() {
        int n = 7;
        n = 29 * n + (this.language != null ? this.language.hashCode() : 0);
        n = 29 * n + (this.mediaType != null ? this.mediaType.hashCode() : 0);
        n = 29 * n + (this.encoding != null ? this.encoding.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Variant variant = (Variant)object;
        if (!(this.language == variant.language || this.language != null && this.language.equals(variant.language))) {
            return false;
        }
        if (!(this.mediaType == variant.mediaType || this.mediaType != null && this.mediaType.equals(variant.mediaType))) {
            return false;
        }
        return this.encoding == variant.encoding || this.encoding != null && this.encoding.equals(variant.encoding);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("Variant[mediaType=");
        stringWriter.append(this.mediaType == null ? "null" : this.mediaType.toString());
        stringWriter.append(", language=");
        stringWriter.append(this.language == null ? "null" : this.language.toString());
        stringWriter.append(", encoding=");
        stringWriter.append(this.encoding == null ? "null" : this.encoding);
        stringWriter.append("]");
        return stringWriter.toString();
    }

    public static abstract class VariantListBuilder {
        protected VariantListBuilder() {
        }

        public static VariantListBuilder newInstance() {
            VariantListBuilder variantListBuilder = RuntimeDelegate.getInstance().createVariantListBuilder();
            return variantListBuilder;
        }

        public abstract List<Variant> build();

        public abstract VariantListBuilder add();

        public abstract VariantListBuilder languages(Locale ... var1);

        public abstract VariantListBuilder encodings(String ... var1);

        public abstract VariantListBuilder mediaTypes(MediaType ... var1);
    }
}

