/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractLocation;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import java.awt.Color;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class XMLReader {
    protected XMLEventReader reader;
    protected XMLEvent event;
    protected Map<String, AbstractLocation> locations = new HashMap<String, AbstractLocation>();
    private static XMLResolver resolver;
    private String inst = null;

    public XMLReader(InputStream s) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        if (resolver != null) {
            inputFactory.setXMLResolver(resolver);
        }
        this.reader = inputFactory.createXMLEventReader(s);
    }

    public static void setXMLResolver(XMLResolver value) {
        resolver = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(Element prototype) throws XMLStreamException {
        Document document = null;
        try {
            if (this.reader.hasNext()) {
                this.next();
                document = new Document(prototype);
                this.nta(document);
            }
        }
        finally {
            this.event = null;
        }
        return document;
    }

    protected void next() throws XMLStreamException {
        this.event = this.reader.nextEvent();
    }

    protected boolean begin(String tag) throws XMLStreamException {
        while (!this.event.isStartElement() && !this.event.isEndDocument()) {
            this.next();
        }
        return !this.event.isEndDocument() && this.event.asStartElement().getName().getLocalPart().equals(tag);
    }

    protected String readText() throws XMLStreamException {
        String s = "";
        while (this.event.isCharacters()) {
            s = s + this.event.asCharacters().getData();
            this.next();
        }
        return s;
    }

    protected String getAttribute(String name) {
        Attribute attribute = this.event.asStartElement().getAttributeByName(new QName(name));
        return attribute == null ? null : attribute.getValue();
    }

    protected Integer getCoordinate(String attribute) {
        try {
            String s = this.getAttribute(attribute);
            return s == null ? null : Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid " + attribute + ": not an integer");
            return null;
        }
    }

    protected Color getColor(String attribute) {
        try {
            String s = this.getAttribute(attribute);
            return s == null ? null : Color.decode(s);
        }
        catch (NumberFormatException e) {
            System.err.println("Not a color: " + attribute);
            return null;
        }
    }

    protected void nta(Document document) throws XMLStreamException {
        this.begin("nta");
        this.next();
        this.declaration(document);
        this.templates(document);
        this.instantiation(document);
        this.system(document);
    }

    protected void declaration(Node node) throws XMLStreamException {
        if (this.begin("declaration")) {
            this.next();
            node.setProperty("declaration", this.readText());
        }
    }

    protected void name(Node node) throws XMLStreamException {
        if (this.begin("name")) {
            Integer x = this.getCoordinate("x");
            Integer y = this.getCoordinate("y");
            Color color = this.getColor("color");
            this.next();
            Property property = node.setProperty("name", this.readText());
            property.setProperty("x", x);
            property.setProperty("color", color);
            property.setProperty("y", y);
        }
    }

    protected void parameter(Template node) throws XMLStreamException {
        if (this.begin("parameter")) {
            this.next();
            node.setProperty("parameter", this.readText());
        }
    }

    protected void labels(Node node) throws XMLStreamException {
        while (this.begin("label")) {
            String kind = this.getAttribute("kind");
            Integer x = this.getCoordinate("x");
            Integer y = this.getCoordinate("y");
            Color color = this.getColor("color");
            this.next();
            if (kind == null) continue;
            Property property = node.setProperty(kind, this.readText());
            property.setProperty("x", x);
            property.setProperty("y", y);
            property.setProperty("color", color);
        }
    }

    protected void committed(Location location) throws XMLStreamException {
        if (this.begin("committed")) {
            this.next();
            location.setProperty("committed", true);
        }
    }

    protected void urgent(Location location) throws XMLStreamException {
        if (this.begin("urgent")) {
            this.next();
            location.setProperty("urgent", true);
        }
    }

    protected void init(Template template) throws XMLStreamException {
        if (this.begin("init")) {
            AbstractLocation location = this.locations.get(this.getAttribute("ref"));
            if (location != null) {
                location.setProperty("init", true);
            }
            this.next();
        }
    }

    protected void locations(Template template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("location")) {
            Location location = template.createLocation();
            location.setProperty("x", this.getCoordinate("x"));
            location.setProperty("y", this.getCoordinate("y"));
            location.setProperty("color", this.getColor("color"));
            this.locations.put(this.getAttribute("id"), location);
            last = template.insert(location, last);
            this.next();
            this.name(location);
            this.labels(location);
            this.urgent(location);
            this.committed(location);
        }
    }

    protected void branchpoints(Template template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("branchpoint")) {
            BranchPoint branchPoint = template.createBranchPoint();
            branchPoint.setProperty("x", this.getCoordinate("x"));
            branchPoint.setProperty("y", this.getCoordinate("y"));
            branchPoint.setProperty("color", this.getColor("color"));
            this.locations.put(this.getAttribute("id"), branchPoint);
            last = template.insert(branchPoint, last);
            this.next();
        }
    }

    protected AbstractLocation source() throws XMLStreamException {
        if (this.begin("source")) {
            AbstractLocation location = this.locations.get(this.getAttribute("ref"));
            this.next();
            return location;
        }
        return null;
    }

    protected AbstractLocation target() throws XMLStreamException {
        if (this.begin("target")) {
            AbstractLocation location = this.locations.get(this.getAttribute("ref"));
            this.next();
            return location;
        }
        return null;
    }

    protected void nails(Edge edge) throws XMLStreamException {
        Node last = edge.getLast();
        while (this.begin("nail")) {
            Integer x = this.getCoordinate("x");
            Integer y = this.getCoordinate("y");
            Nail nail = edge.createNail();
            nail.setProperty("x", x);
            nail.setProperty("y", y);
            last = edge.insert(nail, last);
            this.next();
        }
    }

    protected void edges(Template template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("transition")) {
            String controllable = this.getAttribute("controllable");
            Color color = this.getColor("color");
            this.next();
            AbstractLocation s = this.source();
            AbstractLocation t = this.target();
            if (s != null && t != null) {
                Edge edge = template.createEdge();
                last = template.insert(edge, last);
                if (controllable != null && controllable.equals("false")) {
                    edge.setProperty("controllable", false);
                }
                edge.setSource(s);
                edge.setTarget(t);
                edge.setProperty("color", color);
                this.labels(edge);
                this.nails(edge);
                continue;
            }
            System.err.println("Skipping edge due to invalid source or target");
            while (this.begin("label")) {
                this.next();
            }
            while (this.begin("nail")) {
                this.next();
            }
        }
    }

    protected void templates(Document document) throws XMLStreamException {
        Node last = document.getLast();
        while (this.begin("template")) {
            this.next();
            Template template = document.createTemplate();
            last = document.insert(template, last);
            this.name(template);
            this.parameter(template);
            this.declaration(template);
            this.locations(template);
            this.branchpoints(template);
            this.init(template);
            this.edges(template);
        }
    }

    protected void instantiation(Document document) throws XMLStreamException {
        if (this.begin("instantiation")) {
            this.next();
            this.inst = this.readText();
        }
    }

    protected void system(Document document) throws XMLStreamException {
        if (this.begin("system")) {
            this.next();
            if (this.inst == null) {
                document.setProperty("system", this.readText());
            } else {
                document.setProperty("system", this.inst + "\n" + this.readText());
                this.inst = null;
            }
        }
    }
}

