/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.Parser;
import com.uppaal.engine.Problem;
import com.uppaal.engine.Protocol;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.engine.ServerException;
import com.uppaal.model.core2.Document;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.Transition;
import com.uppaal.model.system.UppaalSystem;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class DotProtocol
implements Protocol {
    private BufferedWriter out;
    private InputStream in;
    private Parser parser;

    public DotProtocol(InputStream in, OutputStream out) {
        this.in = in;
        this.parser = new Parser(this.in);
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(out, "utf-8"));
        }
        catch (Exception e) {
            this.out = new BufferedWriter(new OutputStreamWriter(out));
        }
    }

    @Override
    public void close() throws IOException {
        this.write("quit");
        this.flush();
    }

    @Override
    public SystemState getInitial(UppaalSystem system) throws EngineException, IOException {
        this.write("getInitialState");
        this.flush();
        return this.parser.parseInitial(system);
    }

    @Override
    public String getOptionsInfo() throws EngineException, IOException {
        this.write("getOptionsInfo");
        this.flush();
        return this.parser.parseBlock();
    }

    @Override
    public Vector<Transition> getTransitions(UppaalSystem system, SystemState state) throws EngineException, IOException {
        this.write("getTransitions");
        this.write(state.toServerFormat());
        this.flush();
        return this.parser.parseEnabledTransitions(system);
    }

    @Override
    public String getVersion() throws IOException, EngineException {
        this.write("version");
        this.flush();
        return this.parser.parseBlock();
    }

    @Override
    public char query(UppaalSystem system, String query, QueryFeedback f) throws EngineException, IOException {
        this.write("getSystemInfo");
        this.flush();
        String response = this.parser.parseId();
        if ("ok".equals(response)) {
            f.setProgressAvail(true);
            f.setSystemInfo(this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger());
            this.parser.parseEnd();
        } else if ("error".equals(response)) {
            this.parser.readBlock();
            f.setProgressAvail(false);
        }
        this.write("modelCheck");
        this.write(query);
        this.write(".");
        this.flush();
        while ("progress".equals(response = this.parser.parseId())) {
            f.setProgress(this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger());
            this.parser.parseEnd();
        }
        if ("error".equals(response)) {
            throw new ServerException(this.parser.readBlock());
        }
        if (!"ok".equals(response)) {
            throw new ProtocolException("Ok expected");
        }
        char result = this.parser.parseId().charAt(0);
        String feedback = this.parser.readBlock();
        int length = this.parser.parseInteger();
        int cycle = this.parser.parseInteger();
        if (length >= 0) {
            f.setLength(length);
            Vector<Transition> trace = new Vector<Transition>();
            SystemState src = this.parser.parseState(system);
            trace.add(new Transition(null, null, src));
            for (int current = 0; current < length; ++current) {
                SystemEdge[] edges = this.parser.parseEdges(system);
                SystemState dst = this.parser.parseState(system);
                trace.add(new Transition(src, edges, dst));
                src = dst;
                f.setCurrent(current);
            }
            f.setTrace(result, feedback, trace, cycle);
            this.parser.parseEnd();
        } else {
            f.setFeedback(feedback);
        }
        return result;
    }

    @Override
    public void setOptions(String options) throws EngineException, IOException {
        this.write("setOptions");
        this.write(options);
        this.write(".");
        this.flush();
        this.parser.parseAcknowledgement();
    }

    @Override
    public UppaalSystem upload(Document document, Vector<Problem> problems) throws EngineException, IOException {
        try {
            this.write("newXMLSystem3");
            document.accept(new XMLWriter(this.out));
            this.write("\n");
            this.write(".");
            this.flush();
            this.parser.parseProblems(problems);
            if (this.parser.parseInteger() == 1) {
                return this.parser.parseSystem(document);
            }
            return null;
        }
        catch (EngineException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineException(e.toString());
        }
    }

    @Override
    public UppaalSystem upload(Document document) throws EngineException, IOException {
        try {
            this.write("newXMLSystem3");
            document.accept(new XMLWriter(this.out));
            this.write("\n");
            this.write(".");
            this.flush();
            this.parser.skipProblems();
            if (this.parser.parseInteger() == 1) {
                return this.parser.parseSystem(document);
            }
            return null;
        }
        catch (EngineException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineException(e.toString());
        }
    }

    protected void write(String s) throws IOException {
        this.out.write(s);
        this.out.write(10);
    }

    protected void flush() throws IOException {
        this.out.flush();
    }
}

