/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc.rm;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.rm.Requirement;

@OslcNamespace(value="http://ios.artemis.eu/ns/rm#")
@OslcResourceShape(title="Requirement Suite Resource Shape", describes={"http://ios.artemis.eu/ns/rm#RequirementSuite"})
public class RequirementSuite
extends Requirement {
    private final List<Link> hasParts = new ArrayList<Link>();
    private Link source;

    public RequirementSuite() {
        this.setSpecificationType("Natural language");
        if (!(this instanceof RequirementSuite)) {
            this.addRdfType(this.getRdfType());
        }
    }

    public RequirementSuite(URI about) {
        super(about);
        this.setSpecificationType("Natural language");
        if (!(this instanceof RequirementSuite)) {
            this.addRdfType(this.getRdfType());
        }
    }

    @Override
    protected URI getRdfType() {
        return URI.create("http://ios.artemis.eu/ns/rm#RequirementSuite");
    }

    @Override
    public void reorder() {
        Collections.sort(this.hasParts, compareLinkLabels);
    }

    @OslcDescription(value="Links to the requirement parts of this collection.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/hasPart")
    @OslcName(value="hasPart")
    @OslcTitle(value="Has a Part")
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    public Link[] getHasParts() {
        return this.hasParts.toArray(new Link[this.hasParts.size()]);
    }

    public void addHasPart(Link part) {
        if (part == null) {
            throw new RuntimeException("null object added!");
        }
        this.hasParts.add(part);
    }

    public void setHasParts(Link[] parts) {
        this.hasParts.clear();
        if (parts != null && parts.length > 0) {
            this.hasParts.addAll(Arrays.asList(parts));
        }
    }

    @OslcDescription(value="The resource URI a client can perform a GET to obtain the original requirement text file. The service may use content negotiation with the Accept header to obtain the desired content type.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/rm#source")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcName(value="source")
    @OslcTitle(value="Source")
    @OslcValueType(value=ValueType.Resource)
    public Link getSource() {
        return this.source;
    }

    public void setSource(Link source) {
        this.source = source;
    }
}

