/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTransaction;
import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.Element;
import java.util.ArrayList;

public class TranslationCommand
extends AbstractTransaction {
    protected ArrayList<Element> elements;
    protected int xd;
    protected int yd;

    public TranslationCommand(CommandManager commandManager, ArrayList<Element> elements) {
        super(commandManager);
        this.elements = elements;
        this.yd = 0;
        this.xd = 0;
    }

    protected void moveElements(int x, int y) {
        for (Element element : this.elements) {
            element.setProperty("x", element.getX() + x);
            element.setProperty("y", element.getY() + y);
        }
    }

    @Override
    public void move(int x, int y) {
        assert (!this.committed) : "Cannot move a committed translation";
        this.moveElements(x, y);
        this.xd += x;
        this.yd += y;
    }

    @Override
    protected void doCancel() {
        this.moveElements(-this.xd, -this.yd);
        this.yd = 0;
        this.xd = 0;
    }

    @Override
    protected void doExecute() {
        this.moveElements(this.xd, this.yd);
    }

    @Override
    protected void doUndo() {
        this.moveElements(-this.xd, -this.yd);
    }

    @Override
    public Element getModifiedElement() {
        return this.elements.get(0);
    }
}

