/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.gui.Main;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.QueryProperty;
import com.uppaal.model.core2.Visitor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.DefaultListModel;

public class QueryListModel
extends DefaultListModel<QueryProperty>
implements Cloneable {
    private CommandManager commandManager = new CommandManager();
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public Object clone() throws CloneNotSupportedException {
        QueryListModel clone = new QueryListModel();
        clone.commandManager = (CommandManager)this.commandManager.clone();
        for (int i = 0; i < this.size(); ++i) {
            QueryProperty qp = (QueryProperty)this.getElementAt(i);
            clone.addElement((QueryProperty)qp.clone());
        }
        return clone;
    }

    public int getVersion() {
        return this.getCommandManager().getVersion();
    }

    public void execute(Command command) {
        this.commandManager.execute(command);
    }

    public void setStatus(int index, int status) {
        ((QueryProperty)this.elementAt(index)).setStatus(status);
        this.fireContentsChanged(this, index, index);
    }

    public int getStatus(int index) {
        return ((QueryProperty)this.elementAt(index)).getStatus();
    }

    public void setStatusString(int index, String status) {
        ((QueryProperty)this.elementAt(index)).setStatusString(status);
        this.fireContentsChanged(this, index, index);
    }

    public String getStatusString(int index) {
        return ((QueryProperty)this.elementAt(index)).getStatusString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromTextfile(URL url) throws IOException {
        InputStream is = "file".equals(url.getProtocol()) ? new FileInputStream(url.getPath()) : url.openStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));){
            this.removeAllElements();
            while (reader.ready()) {
                String s = reader.readLine();
                if (s.length() <= 0 || s.startsWith("//")) continue;
                String comment = "";
                if (s.equals("/*")) {
                    s = reader.readLine();
                    if (!s.equals("*/")) {
                        comment = comment + s;
                        s = reader.readLine();
                        while (!s.equals("*/")) {
                            comment = comment + '\n' + s;
                            s = reader.readLine();
                        }
                        comment = comment.replaceAll("([^\\\\]?)\\\\/", "$1/");
                        comment = comment.replaceAll("\\\\\\\\", "\\\\");
                        comment = QueryListModel.decode(comment);
                    }
                    s = reader.readLine();
                }
                StringBuffer property = new StringBuffer();
                if (!s.equals("//NO_QUERY")) {
                    while (s.endsWith("\\")) {
                        property.append(s.substring(0, s.length() - 1)).append('\n');
                        s = reader.readLine();
                    }
                    property.append(s);
                }
                QueryProperty p = new QueryProperty();
                p.setCommentAndProperty(comment, new String(property));
                this.addElement(p);
            }
        }
    }

    public void writeToTextFile(OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, "ISO-8859-1");
        osw.write("//This file was generated from " + Main.getVersion() + "\n");
        for (int i = 0; i < this.size(); ++i) {
            QueryProperty p = (QueryProperty)this.elementAt(i);
            String comment = p.getComment();
            comment = comment.replaceAll("\\\\", "\\\\\\\\");
            comment = comment.replaceAll("/", "\\\\/");
            osw.write("\n/*\n" + QueryListModel.encode(comment) + "\n*/\n");
            String query = p.getFormula();
            query = query.trim().equals("") ? "//NO_QUERY" : query.replaceAll("(?m)\\n", "\\\\\n");
            osw.write(query + "\n");
        }
        osw.flush();
    }

    public QueryProperty addNewQuery(int index) {
        QueryProperty theNew = new QueryProperty();
        this.insertElementAt(theNew, index);
        return theNew;
    }

    private static void byteToHex(StringBuffer buf, byte b) {
        buf.append(hexDigit[b >> 4 & 0xF]).append(hexDigit[b & 0xF]);
    }

    private static String encode(String s) {
        StringBuffer buf = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if ((c & 0xFFFFFF80) == 0) {
                buf.append(c);
                continue;
            }
            byte hi = (byte)(c >>> 8);
            byte lo = (byte)(c & 0xFF);
            buf.append("\\u");
            QueryListModel.byteToHex(buf, hi);
            QueryListModel.byteToHex(buf, lo);
        }
        return buf.toString();
    }

    private static int hexToByte(char c) {
        return c >= 'a' ? 10 + c - 97 : c - 48;
    }

    private static String decode(String s) {
        int i = 0;
        StringBuilder buf = new StringBuilder(s);
        while ((i = buf.indexOf("\\u", i)) >= 0) {
            if (i + 6 > buf.length()) {
                return buf.toString();
            }
            char[] a = new char[4];
            buf.getChars(i + 2, i + 6, a, 0);
            for (int j = 0; j < 4; ++j) {
                if (a[j] >= '0' && a[j] <= '9' || a[j] >= 'a' && a[j] <= 'f') continue;
                return buf.toString();
            }
            char uni = (char)(QueryListModel.hexToByte(a[0]) << 12 | QueryListModel.hexToByte(a[1]) << 8 | QueryListModel.hexToByte(a[2]) << 4 | QueryListModel.hexToByte(a[3]));
            buf.delete(i, i + 6);
            buf.insert(i, uni);
        }
        return buf.toString();
    }

    public void accept(Visitor visitor) throws Exception {
        visitor.visitQueries(this);
    }

    public boolean isBlank() {
        if (this.isEmpty()) {
            return true;
        }
        Enumeration queries = this.elements();
        while (queries.hasMoreElements()) {
            QueryProperty q = (QueryProperty)queries.nextElement();
            if (q.getComment().trim().isEmpty() && q.getFormula().trim().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

