/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Visitor;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Element
implements Cloneable,
Serializable {
    public List<EventListener> listeners;
    public Element prototype;
    Element parent;
    protected Map<String, Property> properties;
    private CommandManager commandManager;

    public Element(Element prototype) {
        this.prototype = prototype;
    }

    public boolean isPropertyLocal(String name) {
        return this.properties != null && this.properties.containsKey(name);
    }

    public Property getProperty(String name) {
        Property property = null;
        if (this.properties != null) {
            property = this.properties.get(name);
        }
        if (property == null && this.prototype != null) {
            property = this.prototype.getProperty(name);
        }
        return property;
    }

    public Property getLocalProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public Object getPropertyValue(String name) {
        Property property = this.getProperty(name);
        return property == null ? null : property.getValue();
    }

    public boolean hasFlag(String property) {
        Object value = this.getPropertyValue(property);
        return value != null && (Boolean)value != false;
    }

    public int getX() {
        return (Integer)this.getPropertyValue("x");
    }

    public int getY() {
        return (Integer)this.getPropertyValue("y");
    }

    public Color getColor() {
        return (Color)this.getPropertyValue("color");
    }

    public Property setProperty(String name, Object value) {
        Property property = null;
        if (this.properties == null) {
            if (value == null) {
                return null;
            }
            this.properties = new HashMap<String, Property>();
        } else {
            property = this.properties.get(name);
        }
        if (property != null && value == null) {
            this.properties.remove(name);
            this.firePropertyChanged(property, name, property.getValue(), null);
            property = null;
        } else if (property == null && value != null) {
            property = new Property(this, this.getProperty(name), value);
            this.properties.put(name, property);
            this.firePropertyChanged(property, name, null, value);
        } else if (property != null && value != null) {
            Object old = property.getValue();
            property.setValue(value);
            this.firePropertyChanged(property, name, old, value);
        }
        return property;
    }

    public void setPropertyFromPath(String path, Object value) {
        Element element = this;
        StringTokenizer tokenizer = new StringTokenizer(path, "/:", true);
        String name = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            element = tokenizer.nextToken().equals(":") ? element.getProperty(name) : (Element)element.getPropertyValue(name);
            name = tokenizer.nextToken();
        }
        element.setProperty(name.intern(), value);
    }

    public void setProperties(Object[] properties) {
        int i = 0;
        while (i < properties.length) {
            String property = properties[i++].toString();
            Object value = properties[i++];
            this.setPropertyFromPath(property, value);
        }
    }

    void restoreProperty(String name, Property property) {
        assert (property != null);
        assert (property.parent == this);
        if (this.properties == null) {
            this.properties = new HashMap<String, Property>();
        }
        assert (!this.properties.containsKey(name));
        this.properties.put(name, property);
        this.firePropertyChanged(property, name, null, property.getValue());
    }

    public Set<Map.Entry<String, Property>> getProperties() {
        return this.properties == null ? null : this.properties.entrySet();
    }

    public Element getParent() {
        return this.parent;
    }

    public void addListener(EventListener l) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<EventListener>();
        }
        this.listeners.add(l);
    }

    public void removeListener(EventListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void accept(Visitor visitor) throws Exception {
        visitor.visitElement(this);
    }

    public void acceptSafe(Visitor visitor) {
        try {
            this.accept(visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)e);
        }
    }

    void firePropertyChanged(Property property, String name, Object old, Object value) {
        if (this.getDocument() != null) {
            Element element = property;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : element.listeners) {
                    l.propertyChanged(property, name, old, value);
                }
            } while ((element = element.prototype) != null);
        }
    }

    public Element getPrototype() {
        return this.prototype;
    }

    public Document getDocument() {
        return this.parent != null ? this.parent.getDocument() : null;
    }

    public AbstractTemplate getTemplate() {
        return this.parent != null ? this.parent.getTemplate() : null;
    }

    public Object clone() throws CloneNotSupportedException {
        Element element = (Element)super.clone();
        element.parent = null;
        element.prototype = null;
        if (this.properties != null) {
            element.properties = new HashMap<String, Property>();
            for (Map.Entry<String, Property> entry : this.getProperties()) {
                String name = entry.getKey();
                Property property = (Property)entry.getValue().clone();
                property.parent = element;
                element.properties.put(name, property);
            }
        }
        if (this.getCommandManager() != null) {
            element.setCommandManager((CommandManager)this.getCommandManager().clone());
        }
        return element;
    }

    public Element getPrototypeFromParent(Element parent) {
        return null;
    }

    public void importInto(Element parent) {
        this.setPrototype(this.getPrototypeFromParent(parent));
    }

    public void setPrototype(Element prototype) {
        this.prototype = prototype;
        if (this.properties != null) {
            for (Map.Entry<String, Property> entry : this.getProperties()) {
                entry.getValue().importInto(this);
            }
        }
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public void setCommandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
    }
}

