/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;

public abstract class Response {
    protected Response() {
    }

    public abstract Object getEntity();

    public abstract int getStatus();

    public abstract MultivaluedMap<String, Object> getMetadata();

    public static ResponseBuilder fromResponse(Response response) {
        ResponseBuilder responseBuilder = Response.status(response.getStatus());
        responseBuilder.entity(response.getEntity());
        for (String string : response.getMetadata().keySet()) {
            List list = (List)response.getMetadata().get(string);
            for (Object e : list) {
                responseBuilder.header(string, e);
            }
        }
        return responseBuilder;
    }

    public static ResponseBuilder status(StatusType statusType) {
        ResponseBuilder responseBuilder = ResponseBuilder.newInstance();
        responseBuilder.status(statusType);
        return responseBuilder;
    }

    public static ResponseBuilder status(Status status) {
        return Response.status((StatusType)status);
    }

    public static ResponseBuilder status(int n) {
        ResponseBuilder responseBuilder = ResponseBuilder.newInstance();
        responseBuilder.status(n);
        return responseBuilder;
    }

    public static ResponseBuilder ok() {
        ResponseBuilder responseBuilder = Response.status(Status.OK);
        return responseBuilder;
    }

    public static ResponseBuilder ok(Object object) {
        ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity(object);
        return responseBuilder;
    }

    public static ResponseBuilder ok(Object object, MediaType mediaType) {
        ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity(object);
        responseBuilder.type(mediaType);
        return responseBuilder;
    }

    public static ResponseBuilder ok(Object object, String string) {
        ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity(object);
        responseBuilder.type(string);
        return responseBuilder;
    }

    public static ResponseBuilder ok(Object object, Variant variant) {
        ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity(object);
        responseBuilder.variant(variant);
        return responseBuilder;
    }

    public static ResponseBuilder serverError() {
        ResponseBuilder responseBuilder = Response.status(Status.INTERNAL_SERVER_ERROR);
        return responseBuilder;
    }

    public static ResponseBuilder created(URI uRI) {
        ResponseBuilder responseBuilder = Response.status(Status.CREATED).location(uRI);
        return responseBuilder;
    }

    public static ResponseBuilder noContent() {
        ResponseBuilder responseBuilder = Response.status(Status.NO_CONTENT);
        return responseBuilder;
    }

    public static ResponseBuilder notModified() {
        ResponseBuilder responseBuilder = Response.status(Status.NOT_MODIFIED);
        return responseBuilder;
    }

    public static ResponseBuilder notModified(EntityTag entityTag) {
        ResponseBuilder responseBuilder = Response.notModified();
        responseBuilder.tag(entityTag);
        return responseBuilder;
    }

    public static ResponseBuilder notModified(String string) {
        ResponseBuilder responseBuilder = Response.notModified();
        responseBuilder.tag(string);
        return responseBuilder;
    }

    public static ResponseBuilder seeOther(URI uRI) {
        ResponseBuilder responseBuilder = Response.status(Status.SEE_OTHER).location(uRI);
        return responseBuilder;
    }

    public static ResponseBuilder temporaryRedirect(URI uRI) {
        ResponseBuilder responseBuilder = Response.status(Status.TEMPORARY_REDIRECT).location(uRI);
        return responseBuilder;
    }

    public static ResponseBuilder notAcceptable(List<Variant> list) {
        ResponseBuilder responseBuilder = Response.status(Status.NOT_ACCEPTABLE).variants(list);
        return responseBuilder;
    }

    public static enum Status implements StatusType
    {
        OK(200, "OK"),
        CREATED(201, "Created"),
        ACCEPTED(202, "Accepted"),
        NO_CONTENT(204, "No Content"),
        MOVED_PERMANENTLY(301, "Moved Permanently"),
        SEE_OTHER(303, "See Other"),
        NOT_MODIFIED(304, "Not Modified"),
        TEMPORARY_REDIRECT(307, "Temporary Redirect"),
        BAD_REQUEST(400, "Bad Request"),
        UNAUTHORIZED(401, "Unauthorized"),
        FORBIDDEN(403, "Forbidden"),
        NOT_FOUND(404, "Not Found"),
        NOT_ACCEPTABLE(406, "Not Acceptable"),
        CONFLICT(409, "Conflict"),
        GONE(410, "Gone"),
        PRECONDITION_FAILED(412, "Precondition Failed"),
        UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
        INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
        SERVICE_UNAVAILABLE(503, "Service Unavailable");

        private final int code;
        private final String reason;
        private Family family;

        private Status(int n2, String string2) {
            this.code = n2;
            this.reason = string2;
            switch (this.code / 100) {
                case 1: {
                    this.family = Family.INFORMATIONAL;
                    break;
                }
                case 2: {
                    this.family = Family.SUCCESSFUL;
                    break;
                }
                case 3: {
                    this.family = Family.REDIRECTION;
                    break;
                }
                case 4: {
                    this.family = Family.CLIENT_ERROR;
                    break;
                }
                case 5: {
                    this.family = Family.SERVER_ERROR;
                    break;
                }
                default: {
                    this.family = Family.OTHER;
                }
            }
        }

        @Override
        public Family getFamily() {
            return this.family;
        }

        @Override
        public int getStatusCode() {
            return this.code;
        }

        @Override
        public String getReasonPhrase() {
            return this.toString();
        }

        public String toString() {
            return this.reason;
        }

        public static Status fromStatusCode(int n) {
            for (Status status : Status.values()) {
                if (status.code != n) continue;
                return status;
            }
            return null;
        }

        public static enum Family {
            INFORMATIONAL,
            SUCCESSFUL,
            REDIRECTION,
            CLIENT_ERROR,
            SERVER_ERROR,
            OTHER;

        }
    }

    public static interface StatusType {
        public int getStatusCode();

        public Status.Family getFamily();

        public String getReasonPhrase();
    }

    public static abstract class ResponseBuilder {
        protected ResponseBuilder() {
        }

        protected static ResponseBuilder newInstance() {
            ResponseBuilder responseBuilder = RuntimeDelegate.getInstance().createResponseBuilder();
            return responseBuilder;
        }

        public abstract Response build();

        public abstract ResponseBuilder clone();

        public abstract ResponseBuilder status(int var1);

        public ResponseBuilder status(StatusType statusType) {
            if (statusType == null) {
                throw new IllegalArgumentException();
            }
            return this.status(statusType.getStatusCode());
        }

        public ResponseBuilder status(Status status) {
            return this.status((StatusType)status);
        }

        public abstract ResponseBuilder entity(Object var1);

        public abstract ResponseBuilder type(MediaType var1);

        public abstract ResponseBuilder type(String var1);

        public abstract ResponseBuilder variant(Variant var1);

        public abstract ResponseBuilder variants(List<Variant> var1);

        public abstract ResponseBuilder language(String var1);

        public abstract ResponseBuilder language(Locale var1);

        public abstract ResponseBuilder location(URI var1);

        public abstract ResponseBuilder contentLocation(URI var1);

        public abstract ResponseBuilder tag(EntityTag var1);

        public abstract ResponseBuilder tag(String var1);

        public abstract ResponseBuilder lastModified(Date var1);

        public abstract ResponseBuilder cacheControl(CacheControl var1);

        public abstract ResponseBuilder expires(Date var1);

        public abstract ResponseBuilder header(String var1, Object var2);

        public abstract ResponseBuilder cookie(NewCookie ... var1);
    }
}

