/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system.symbolic;

import com.uppaal.model.system.AbstractTransition;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.symbolic.SymbolicState;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class SymbolicTransition
extends AbstractTransition {
    private SymbolicState source;
    private SymbolicState target;
    private String edgeDescription;

    public SymbolicTransition(SymbolicState source, SystemEdgeSelect[] edges, SymbolicState target) {
        this(source, edges, target, null);
    }

    public SymbolicTransition(SymbolicState source, SystemEdgeSelect[] edges, SymbolicState target, String edgeDescription) {
        super(edges);
        this.source = source;
        this.target = target;
        this.edgeDescription = edgeDescription != null ? edgeDescription : this.getTransitionDescription();
    }

    public String traceFormat() {
        StringBuilder s = new StringBuilder("(");
        boolean start = true;
        for (SystemEdgeSelect edge : this.edges_ws) {
            if (start) {
                start = false;
            } else {
                s.append(", ");
            }
            s.append(edge.getFormatedName());
        }
        s.append(')');
        return s.toString();
    }

    public String toServerFormat() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.edges_ws.length);
        for (SystemEdgeSelect edge : this.edges_ws) {
            buf.append('\n');
            buf.append(edge.getProcess().getIndex()).append('\n');
            buf.append(edge.getIndex() + 1);
        }
        return buf.toString();
    }

    public String toXTRFormat() {
        StringBuilder sb = new StringBuilder();
        for (SystemEdgeSelect edge : this.edges_ws) {
            sb.append(edge.getProcess().getIndex()).append(' ');
            sb.append(edge.getIndex() + 1).append('\n');
        }
        sb.append(".\n");
        return sb.toString();
    }

    public void writeXTRFormat(Writer writer) throws IOException {
        this.getTarget().writeXTRFormat(writer);
        for (SystemEdgeSelect edge : this.edges_ws) {
            edge.writeXTRFormat(writer);
        }
        writer.write(".\n");
    }

    public SymbolicState getSource() {
        return this.source;
    }

    public SymbolicState getTarget() {
        return this.target;
    }

    public boolean involvesProcess(int process) {
        for (SystemEdgeSelect edge : this.edges_ws) {
            if (edge.getProcess().getIndex() != process) continue;
            return true;
        }
        return false;
    }

    public String getEdgeDescription() {
        return this.edgeDescription;
    }

    private static String makeEdgeDescription(SystemEdge[] edges) {
        if (edges == null) {
            return null;
        }
        if (edges.length == 0) {
            return "deadlock";
        }
        String channel = edges[0].getName();
        if (channel != null && channel.length() > 0) {
            String channelName = channel.substring(0, channel.length() - 1);
            LinkedHashSet<String> processNames = new LinkedHashSet<String>();
            for (SystemEdge e : edges) {
                processNames.add(e.getProcessName());
            }
            Iterator namesIter = processNames.iterator();
            StringBuilder s = new StringBuilder();
            s.append(channelName);
            s.append(": ");
            s.append((String)namesIter.next());
            if (edges.length == 1 || edges.length > 2) {
                s.append(" \u21d2 ");
            } else {
                s.append(" \u2192 ");
            }
            while (namesIter.hasNext()) {
                s.append((String)namesIter.next());
                if (!namesIter.hasNext()) continue;
                s.append(", ");
            }
            return s.toString();
        }
        return edges[0].getProcessName();
    }
}

