/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.AbstractSystem;
import com.uppaal.model.Translator;
import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscTemplate;
import com.uppaal.model.core2.lsc.Message;
import com.uppaal.model.core2.lsc.Prechart;
import com.uppaal.model.core2.lsc.Update;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.GanttChart;
import com.uppaal.model.system.Process;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.SystemLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UppaalSystem
extends AbstractSystem {
    private final ArrayList<Process> processes = new ArrayList();
    private final Map<String, AbstractTemplate> templates = new HashMap<String, AbstractTemplate>();
    private GanttChart ganttchart;

    public UppaalSystem(Document aDocument) {
        super(aDocument);
        for (Node node = this.document.getFirst(); node != null; node = node.getNext()) {
            this.templates.put((String)node.getPropertyValue("name"), (AbstractTemplate)node);
        }
    }

    @Override
    public void addProcess(String processName, String templateName, Translator map) {
        Node node;
        templateName = templateName.trim();
        processName = processName.trim();
        for (node = this.document.getFirst(); node != null && !templateName.equals(((String)node.getPropertyValue("name")).trim()); node = node.getNext()) {
        }
        assert (node != null) : "Template " + templateName + " not found.";
        final Process p = new Process(processName, this.processes.size(), (Template)node, map);
        node.acceptSafe(new AbstractVisitor(){

            @Override
            public void visitLocation(Location location) {
                p.addLocation(location);
            }

            @Override
            public void visitEdge(Edge edge) {
                p.addEdge(edge);
            }
        });
        this.processes.add(p);
    }

    public void addProcess(String processName, String templateName, Translator parameterMap, List<Integer> edgeMap) {
        Node node;
        templateName = templateName.trim();
        processName = processName.trim();
        for (node = this.document.getFirst(); node != null && !templateName.equals(((String)node.getPropertyValue("name")).trim()); node = node.getNext()) {
        }
        assert (node != null) : "Template " + templateName + " not found.";
        final Process p = new Process(processName, this.processes.size(), (Template)node, parameterMap);
        node.acceptSafe(new AbstractVisitor(){

            @Override
            public void visitLocation(Location location) {
                p.addLocation(location);
            }
        });
        ArrayList edges = new ArrayList();
        node.acceptSafe(new AbstractVisitor(){

            @Override
            public void visitEdge(Edge edge) {
                p.addEdge(edge);
            }
        });
        this.processes.add(p);
    }

    public void setLscProcess(String processName, String templateName, Translator map) {
        Node node;
        templateName = templateName.trim();
        processName = processName.trim();
        for (node = this.document.getFirst(); node != null && !templateName.equals(((String)node.getPropertyValue("name")).trim()); node = node.getNext()) {
        }
        assert (node != null) : "Template " + templateName + " not found.";
        final LscProcess p = new LscProcess(processName, this.processes.size(), (LscTemplate)node, map);
        node.acceptSafe(new AbstractVisitor(){

            @Override
            public void visitPrechart(Prechart prechart) {
                p.setPrechart(prechart);
            }

            @Override
            public void visitMessage(Message message) {
                p.addMessage(message);
            }

            @Override
            public void visitCondition(Condition condition) {
                p.addCondition(condition);
            }

            @Override
            public void visitUpdate(Update update) {
                p.addUpdate(update);
            }

            @Override
            public void visitInstanceLine(InstanceLine instance) {
                p.addInstanceLine(instance);
            }
        });
    }

    public Process getProcess(int process) {
        return this.processes.get(process);
    }

    public SystemEdge getEdge(int process, int edge) {
        return this.getProcess(process).getEdge(edge);
    }

    public ArrayList<Process> getProcesses() {
        return this.processes;
    }

    public SystemLocation getLocation(int process, int loc) {
        return this.getProcess(process).getLocation(loc);
    }

    public int getNoOfProcesses() {
        return this.processes.size();
    }

    public int getProcessIndex(String id) {
        for (int i = 0; i < this.processes.size(); ++i) {
            if (!id.equals(this.getProcess(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public SystemEdgeSelect createEdgeCon(int process, int edge, List<Integer> values) {
        return new SystemEdgeSelect(this.getProcess(process).getEdge(edge), values);
    }

    public void setGanttChart(GanttChart gc) {
        this.ganttchart = gc;
    }

    public GanttChart getGanttChart() {
        return this.ganttchart;
    }
}

