/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.GanttRow;
import com.uppaal.model.system.concrete.Limit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GanttChart
implements Cloneable {
    private final List<GanttRow> rows = new ArrayList<GanttRow>();

    public void addRow(GanttRow row) {
        this.rows.add(row);
    }

    public int noOfRows() {
        return this.rows.size();
    }

    public GanttRow getRow(int i) {
        return this.rows.get(i);
    }

    public void truncate(BigDecimal t) {
        for (GanttRow r : this.rows) {
            r.truncate(t);
        }
    }

    public void truncate(int from) {
        this.truncate(new BigDecimal(from));
    }

    public void clearChart() {
        Iterator<GanttRow> i = this.rows.iterator();
        while (i.hasNext()) {
            i.next().clearRow();
        }
    }

    public Limit maximalNonInfiniteEndTime() {
        Limit tmp = new Limit(new BigDecimal(0), true);
        boolean flagInfinite = true;
        for (GanttRow r : this.rows) {
            Limit rowEndTime = r.maximalNonInfiniteEndTime();
            if (rowEndTime.isUnbounded() || !rowEndTime.isUpperBoundOf(tmp.getValue())) continue;
            tmp = rowEndTime;
            flagInfinite = false;
        }
        if (flagInfinite) {
            tmp.setValue(null);
        }
        return tmp;
    }

    public void printGanttInfo() {
        System.out.println();
        System.out.println("Gantt bar dump");
        System.out.println("Number of rows: " + this.rows.size());
        System.out.println();
        for (int i = 0; i < this.rows.size(); ++i) {
            System.out.print("Row: " + i + " ");
            this.rows.get(i).printRowInfo();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GanttChart theClone = new GanttChart();
        for (GanttRow row : this.rows) {
            theClone.rows.add((GanttRow)row.clone());
        }
        return theClone;
    }
}

