/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2.lsc;

import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.TranslationCommand;
import com.uppaal.model.core2.lsc.LscConstants;
import com.uppaal.model.core2.lsc.LscTemplate;
import com.uppaal.model.core2.lsc.Message;
import com.uppaal.model.core2.lsc.ViewWorkAround;
import java.util.ArrayList;

public class TranslationYCommand
extends TranslationCommand
implements LscConstants {
    protected int oldLength = ((LscTemplate)this.getModifiedElement().getTemplate()).getLength();
    protected int newLength = 0;
    protected ViewWorkAround view;
    protected boolean resize = false;

    public TranslationYCommand(CommandManager commandManager, ArrayList<Element> elements) {
        super(commandManager, elements);
    }

    private void moveElements(int y) {
        for (Element element : this.elements) {
            if (element.getParent() instanceof Message) continue;
            element.setProperty("y", element.getY() + y);
        }
    }

    public void move(int y) {
        assert (!this.committed) : "Cannot move a committed translation";
        if (this.getYMin() + y >= 30) {
            this.moveElements(y);
            this.yd += y;
        }
    }

    private int getYMin() {
        int min = this.getModifiedElement().getY();
        if (this.getModifiedElement().getParent() instanceof Message) {
            min = this.getModifiedElement().getParent().getY();
        }
        for (Element element : this.elements) {
            int y = element.getY();
            if (element.getParent() instanceof Message) {
                y = element.getParent().getY();
            }
            if (y >= min) continue;
            min = y;
        }
        return min;
    }

    public void resizeIfNecessary(ViewWorkAround view) {
        int length;
        int ymax = this.GetYMax();
        if (ymax <= 10 + (length = ((LscTemplate)this.getModifiedElement().getTemplate()).getLength()) - 20) {
            return;
        }
        this.view = view;
        this.newLength = ymax + 20;
        this.resize = true;
        ((LscTemplate)this.getModifiedElement().getTemplate()).setLength(this.newLength - 10, view);
    }

    private int GetYMax() {
        int y = 0;
        for (Element element : this.elements) {
            int ye = element.getY();
            if (element.getParent() instanceof Message) {
                ye = element.getParent().getY();
            }
            if (ye <= y) continue;
            y = ye;
        }
        return y;
    }

    @Override
    protected void doCancel() {
        this.moveElements(-this.yd);
        if (this.resize) {
            ((LscTemplate)this.getModifiedElement().getTemplate()).setLength(this.oldLength, this.view);
        }
        this.yd = 0;
    }

    @Override
    protected void doExecute() {
        this.moveElements(this.yd);
        if (this.resize) {
            ((LscTemplate)this.getModifiedElement().getTemplate()).setLength(this.newLength, this.view);
        }
    }

    @Override
    protected void doUndo() {
        this.moveElements(-this.yd);
        if (this.resize) {
            ((LscTemplate)this.getModifiedElement().getTemplate()).setLength(this.oldLength, this.view);
        }
    }
}

