/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractCommand;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.QueryProperty;

public class SetQueryCommand
extends AbstractCommand {
    private final QueryProperty queryProperty;
    private final String oldProperty;
    private String newProperty;
    private final String oldComment;
    private String newComment;
    private boolean isRedo;

    public SetQueryCommand(QueryProperty queryProperty, String oldProperty, String oldComment, String newProperty, String newComment) {
        this.queryProperty = queryProperty;
        this.oldProperty = oldProperty;
        this.oldComment = oldComment;
        this.newProperty = newProperty;
        this.newComment = newComment;
    }

    @Override
    public void execute() {
        if (this.isRedo) {
            this.queryProperty.setCommentAndProperty(this.newComment, this.newProperty);
        }
        this.isRedo = true;
    }

    @Override
    public void undo() {
        this.queryProperty.setCommentAndProperty(this.oldComment, this.oldProperty);
    }

    @Override
    public Element getModifiedElement() {
        return null;
    }

    public QueryProperty getQueryProperty() {
        return this.queryProperty;
    }

    public void setText(String newProperty, String newComment) {
        this.newProperty = newProperty;
        this.newComment = newComment;
    }
}

