/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.DataSet2D;
import com.uppaal.model.core2.QueryPropertyListener;
import com.uppaal.model.core2.Visitor;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;

public class QueryProperty
extends Observable
implements DocumentListener {
    private final PlainDocument theFormula;
    private final PlainDocument theComment;
    AttributeSet myStyle = new SimpleAttributeSet();
    public static final int OKAY = 1;
    public static final int NOT_OKAY = 2;
    public static final int MAYBE_OK = 3;
    public static final int UNCHECKED = 4;
    public static final int MAYBE_NOT_OK = 5;
    private int status = 4;
    private String statusString;
    private final ArrayList<String> dataTitles = new ArrayList();
    private final ArrayList<DataSet2D> data = new ArrayList();
    private final ArrayList<QueryPropertyListener> queryPropertylisteners = new ArrayList();
    private boolean isModifiedBySetMethod;

    public QueryProperty(String prop, String comm) {
        this();
        try {
            this.theFormula.insertString(0, prop, this.myStyle);
            this.theComment.insertString(0, comm, this.myStyle);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public QueryProperty() {
        this.theFormula = new PlainDocument();
        this.theComment = new PlainDocument();
        this.theFormula.addDocumentListener(this);
        this.theComment.addDocumentListener(this);
    }

    public void addQueryPropertyListener(QueryPropertyListener l) {
        this.queryPropertylisteners.add(l);
    }

    public Object clone() throws CloneNotSupportedException {
        QueryProperty clone = new QueryProperty(this.getFormula(), this.getComment());
        return clone;
    }

    public String getFormula() {
        try {
            return this.theFormula.getText(0, this.theFormula.getLength());
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    public PlainDocument getFormulaDocument() {
        return this.theFormula;
    }

    public String getComment() {
        try {
            return this.theComment.getText(0, this.theComment.getLength());
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    public void setCommentAndProperty(String comment, String queryProperty) {
        try {
            this.isModifiedBySetMethod = true;
            this.theComment.remove(0, this.theComment.getLength());
            this.theComment.insertString(0, comment, this.myStyle);
            this.theFormula.remove(0, this.theFormula.getLength());
            this.theFormula.insertString(0, queryProperty, this.myStyle);
            this.isModifiedBySetMethod = false;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isChangedBySetMethod() {
        return this.isModifiedBySetMethod;
    }

    public PlainDocument getCommentDocument() {
        return this.theComment;
    }

    public void setStatus(int i) {
        this.status = i;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatusString(String str) {
        this.statusString = str;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public String getShortFormula() {
        String s = this.getFormula();
        StringBuffer out = new StringBuffer();
        int j = 0;
        int k = s.indexOf(10);
        while (k > -1) {
            out.append(s.substring(j, k).trim()).append(' ');
            j = k + 1;
            k = s.indexOf(10, j);
        }
        out.append(s.substring(j).trim());
        return new String(out);
    }

    public void clearData() {
        this.data.clear();
        this.dataTitles.clear();
        this.setChanged();
    }

    public void addData(DataSet2D dataset) {
        this.data.add(dataset);
        this.dataTitles.add(dataset.getTitle());
        this.setChanged();
    }

    public void notifyDataObservers() {
        this.notifyObservers("Data");
    }

    public ArrayList<String> getDataTitles() {
        return this.dataTitles;
    }

    public DataSet2D getData(String title) {
        int i = this.dataTitles.indexOf(title);
        if (i >= 0) {
            return this.data.get(i);
        }
        return null;
    }

    public void accept(Visitor visitor) throws Exception {
        visitor.visitQuery(this);
    }

    private void notifyQueryPropertyListeners() {
        for (QueryPropertyListener l : this.queryPropertylisteners) {
            l.queryChanged(this);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.notifyQueryPropertyListeners();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.notifyQueryPropertyListeners();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.notifyQueryPropertyListeners();
    }
}

