/*
 * Decompiled with CFR 0.152.
 */
package org.uppaal.oslc.qm;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.uppaal.oslc.AuthoredVersionedResource;

@OslcNamespace(value="http://ios.artemis.eu/ns/vv#")
@OslcResourceShape(title="IOS VVLog Resource Shape", describes={"http://ios.artemis.eu/ns/vv#VVLog"})
public class VVLog
extends AuthoredVersionedResource {
    private String status;
    private List<Link> outcome = new ArrayList<Link>();

    public VVLog() {
        if (!(this instanceof VVLog)) {
            this.addRdfType(this.getRdfType());
        }
    }

    public VVLog(URI about) {
        super(about);
        if (!(this instanceof VVLog)) {
            this.addRdfType(this.getRdfType());
        }
    }

    @Override
    public void reorder() {
        Collections.sort(this.outcome, compareLinks);
    }

    @Override
    protected URI getRdfType() {
        return URI.create("http://ios.artemis.eu/ns/vv#VVLog");
    }

    @OslcDescription(value="Used to indicate the state of the VV Log based on values defined by the service provider. Most often a read-only property. Defines whether a VV Case has been successfully executed or not.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#status")
    @OslcName(value="status")
    @OslcTitle(value="Status")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcAllowedValue(value={"success", "error"})
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @OslcDescription(value="A set of outcomes produced as a result of a test or analysis task.")
    @OslcPropertyDefinition(value="http://ios.artemis.eu/ns/vv#outcome")
    @OslcName(value="outcome")
    @OslcTitle(value="Outcome")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://ios.artemis.eu/ns/vv#VVOutcome"})
    public Link[] getOutcome() {
        return this.outcome.toArray(new Link[this.outcome.size()]);
    }

    public void addOutcome(Link outcome) {
        this.outcome.add(outcome);
    }

    public void setOutcome(Link[] outcome) {
        this.outcome.clear();
        if (outcome != null && outcome.length > 0) {
            this.outcome.addAll(Arrays.asList(outcome));
        }
    }
}

