/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.GanttBar;
import com.uppaal.model.system.concrete.Limit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GanttRow
implements Cloneable {
    public List<GanttBar> row = new ArrayList<GanttBar>();
    public String label;

    public GanttRow() {
    }

    public GanttRow(String l) {
        this.label = new String(l);
    }

    public void clearRow() {
        this.row.clear();
    }

    public void addBar(GanttBar b) {
        if (b.toTime.isEqualTo(b.fromTime.getValue())) {
            return;
        }
        if (b.fromTime.isUnbounded()) {
            return;
        }
        if (this.row.size() > 0) {
            GanttBar lastBar = this.row.get(this.row.size() - 1);
            if (lastBar.value == b.value && lastBar.fromTime.isLowerBoundOf(b.fromTime) && lastBar.toTime.isUpperBoundOf(b.fromTime)) {
                lastBar.toTime = b.toTime;
                return;
            }
            for (int i = 0; i < this.row.size(); ++i) {
                GanttBar tmpBar = this.row.get(i);
                if (!b.fromTime.isStrictLowerBoundOf(tmpBar.toTime) || !b.toTime.isStrictUpperBoundOf(tmpBar.fromTime)) continue;
                b.overlaps = true;
            }
        }
        this.row.add(b);
    }

    public int noOfBars() {
        return this.row.size();
    }

    public GanttBar getFromNum(int i) {
        return this.row.get(i);
    }

    public void printRowInfo() {
        System.out.println("No of bars " + this.row.size());
    }

    public void truncate(BigDecimal t) {
        Iterator<GanttBar> i = this.row.iterator();
        while (i.hasNext()) {
            GanttBar b = i.next();
            if (b.toTime.isUnbounded()) {
                b.toTime.setValue(t);
                b.toTime.setStrict(true);
            }
            if (b.fromTime.isUpperBoundOf(t)) {
                i.remove();
            } else if (b.toTime.isUpperBoundOf(t)) {
                b.toTime.setValue(t);
            }
            b.toTime.setStrict(true);
        }
    }

    public Limit maximalEndTime() {
        Limit tmp = new Limit(new BigDecimal(0), true);
        for (GanttBar b : this.row) {
            if (b.toTime.isUnbounded()) {
                tmp.setValue(null);
                return tmp;
            }
            if (!b.toTime.isUpperBoundOf(tmp.getValue())) continue;
            tmp = b.toTime;
        }
        return tmp;
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        GanttRow theClone = new GanttRow(this.label);
        for (int i = 0; i < this.row.size(); ++i) {
            theClone.row.add((GanttBar)this.row.get(i).clone());
        }
        return theClone;
    }
}

