/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.SystemEdgeSelect;

public abstract class AbstractTransition {
    protected SystemEdgeSelect[] edges_ws;

    public AbstractTransition(SystemEdgeSelect[] edges) {
        this.edges_ws = edges;
    }

    public String getTransitionDescription() {
        String channel;
        if (this.edges_ws == null) {
            return null;
        }
        boolean broadcast = false;
        switch (this.edges_ws.length) {
            case 0: {
                return "deadlock";
            }
            case 1: {
                StringBuilder s1 = new StringBuilder();
                String channel1 = this.edges_ws[0].getName();
                if (channel1.length() > 0) {
                    s1.append(channel1.substring(0, channel1.length() - 1));
                    s1.append(": ");
                    broadcast = true;
                }
                s1.append(this.edges_ws[0].getProcessName());
                if (this.edges_ws[0].getSelectList().size() > 0) {
                    s1.append(this.edges_ws[0].getSelectList());
                }
                if (broadcast) {
                    s1.append(" \u2192 ");
                }
                return s1.toString();
            }
        }
        StringBuilder s = new StringBuilder();
        int lastindex = 0;
        if (this.edges_ws[0].getProcessName().equals(this.edges_ws[1].getProcessName())) {
            channel = this.edges_ws[1].getName();
            if (channel.length() > 0) {
                s.append(channel.substring(0, channel.length() - 1));
                s.append(": ");
            }
            s.append(this.edges_ws[0].getProcessName());
            if (this.edges_ws[0].getSelectList().size() > 0 || this.edges_ws[1].getSelectList().size() > 0) {
                s.append(this.edges_ws[1].getSelectList());
                s.append(this.edges_ws[0].getSelectList());
            }
            lastindex = 1;
        } else {
            channel = this.edges_ws[0].getName();
            if (channel.length() > 0) {
                s.append(channel.substring(0, channel.length() - 1));
                s.append(": ");
            }
            s.append(this.edges_ws[0].getProcessName());
            if (this.edges_ws[0].getSelectList().size() > 0) {
                s.append(this.edges_ws[0].getSelectList());
                lastindex = 0;
            }
        }
        s.append(" \u2192 ");
        int i = lastindex + 1;
        while (i < this.edges_ws.length - 1) {
            if (this.edges_ws[i].getProcessName().equals(this.edges_ws[i + 1].getProcessName())) {
                s.append(this.edges_ws[i].getProcessName());
                if (this.edges_ws[i].getSelectList().size() > 0 || this.edges_ws[i + 1].getSelectList().size() > 0) {
                    s.append(this.edges_ws[i + 1].getSelectList());
                    s.append(this.edges_ws[i].getSelectList());
                }
                i += 2;
                continue;
            }
            s.append(this.edges_ws[i].getProcessName());
            if (this.edges_ws[i].getSelectList().size() > 0) {
                s.append(this.edges_ws[i].getSelectList());
            }
            ++i;
        }
        if (i == this.edges_ws.length - 1) {
            s.append(this.edges_ws[i].getProcessName());
            if (this.edges_ws[i].getSelectList().size() > 0) {
                s.append(this.edges_ws[i].getSelectList());
            }
        }
        return s.toString();
    }

    public SystemEdgeSelect[] getEdges() {
        return this.edges_ws;
    }

    public void setEdges(SystemEdgeSelect[] e) {
        this.edges_ws = e;
    }

    public SystemEdgeSelect getEdge(int i) {
        return this.edges_ws[i];
    }

    public int getSize() {
        return this.edges_ws.length;
    }
}

