/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.Translator;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.system.EmptyTranslator;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class BoundCalc
extends AbstractVisitor {
    private Rectangle2D bounds = new Rectangle2D.Double();
    private boolean empty = true;
    private Translator translator;
    static final double lHeight = 14.0;
    static final Graphics context;
    public static final FontMetrics plainMetrics;
    public static final FontMetrics boldMetrics;

    public static double plainWidth(String s) {
        return Math.ceil(plainMetrics.getStringBounds(s, context).getWidth());
    }

    public static double boldWidth(String s) {
        return Math.ceil(boldMetrics.getStringBounds(s, context).getWidth());
    }

    public BoundCalc() {
        this(new EmptyTranslator());
    }

    public BoundCalc(Translator aTranslator) {
        this.translator = aTranslator;
        this.bounds.setRect(0.0, 0.0, 0.0, 0.0);
        this.empty = true;
    }

    private void draw(Property property, FontMetrics metrics) throws IOException {
        if (property == null) {
            return;
        }
        Object value = property.getValue();
        if (!(value instanceof String)) {
            return;
        }
        String line = this.translator.translate((String)value);
        if (line.length() > 0) {
            Rectangle2D b;
            int l = 0;
            int lastpos = 0;
            int x = (Integer)property.getPropertyValue("x");
            int y = (Integer)property.getPropertyValue("y");
            if (this.empty) {
                this.bounds.setRect(x, y, 8.0, 8.0);
                this.empty = false;
            } else {
                this.bounds.add(x, y);
                this.bounds.add(x + 8, y + 8);
            }
            int pos = line.indexOf(10, lastpos);
            while (pos >= 0) {
                if (pos > lastpos) {
                    b = metrics.getStringBounds(line, lastpos, pos, null);
                    this.bounds.add((double)x + b.getMaxX(), (double)y + (double)l * 14.0 + b.getMaxY());
                }
                lastpos = pos + 1;
                pos = line.indexOf(10, lastpos);
                ++l;
            }
            if (line.length() > lastpos) {
                b = metrics.getStringBounds(line, lastpos, line.length(), null);
                this.bounds.add((double)x + b.getMaxX(), (double)y + (double)l * 14.0 + b.getMaxY());
            }
        }
    }

    protected void draw(Element element, double margin) {
        int x = (Integer)element.getPropertyValue("x");
        int y = (Integer)element.getPropertyValue("y");
        if (this.empty) {
            this.bounds.setRect((double)x - margin, (double)y - margin, 2.0 * margin, 2.0 * margin);
            this.empty = false;
        } else {
            this.bounds.add((double)x - margin, (double)y - margin);
            this.bounds.add((double)x + margin, (double)y + margin);
        }
    }

    private void draw(Edge edge) {
        for (Node node = edge.getFirst(); node != null; node = node.getNext()) {
            this.draw(node, 5.0);
        }
    }

    @Override
    public void visitLocation(Location location) throws Exception {
        this.draw(location, 12.0);
        this.draw(location.getProperty("name"), boldMetrics);
        this.draw(location.getProperty("invariant"), boldMetrics);
        this.draw(location.getProperty("exponentialrate"), boldMetrics);
        this.draw(location.getProperty("comments"), plainMetrics);
    }

    @Override
    public void visitBranchPoint(BranchPoint branchPoint) throws Exception {
        this.draw(branchPoint, 5.0);
    }

    @Override
    public void visitEdge(Edge edge) throws Exception {
        this.draw(edge);
        this.draw(edge.getProperty("select"), plainMetrics);
        this.draw(edge.getProperty("guard"), plainMetrics);
        this.draw(edge.getProperty("synchronisation"), plainMetrics);
        this.draw(edge.getProperty("assignment"), plainMetrics);
        this.draw(edge.getProperty("comments"), plainMetrics);
    }

    public Rectangle2D getBounds(Element e) {
        this.bounds.setRect(0.0, 0.0, 0.0, 0.0);
        this.empty = true;
        e.acceptSafe(this);
        if (this.empty) {
            return null;
        }
        return new Rectangle2D.Double(this.bounds.getMinX(), this.bounds.getMinY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    static {
        BufferedImage i = new BufferedImage(1, 1, 1);
        context = i.createGraphics();
        plainMetrics = context.getFontMetrics(new Font("Helvetica", 0, 14));
        boldMetrics = context.getFontMetrics(new Font("Helvetica", 1, 14));
    }
}

