/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2.lsc;

import com.uppaal.model.core2.AbstractTransaction;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscConstants;
import com.uppaal.model.core2.lsc.ViewWorkAround;

public class SetLengthCommand
extends AbstractTransaction
implements LscConstants {
    protected int oldLength = 0;
    protected InstanceLine element;
    protected int newLength = 0;
    private ViewWorkAround view;

    public SetLengthCommand(Document document, Element element, ViewWorkAround view) {
        super(document);
        this.element = (InstanceLine)element;
        this.oldLength = ((InstanceLine)element).getLength();
        this.view = view;
    }

    public void resize(int y) {
        this.element.setLength(y - 2, this.view);
        this.newLength = y;
    }

    @Override
    protected void doCancel() {
        this.element.setLength(this.oldLength, this.view);
        this.newLength = this.oldLength;
    }

    @Override
    protected void doExecute() {
        this.element.setLength(this.newLength, this.view);
    }

    @Override
    protected void doUndo() {
        this.element.setLength(this.oldLength, this.view);
    }

    @Override
    public Element getModifiedElement() {
        return this.element;
    }
}

