/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractLocation;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Template;
import com.uppaal.model.io2.ParseException;
import com.uppaal.model.io2.SimpleCharStream;
import com.uppaal.model.io2.Token;
import com.uppaal.model.io2.XTAReaderConstants;
import com.uppaal.model.io2.XTAReaderTokenManager;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class XTAReader
implements XTAReaderConstants {
    private String errors = null;
    public XTAReaderTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[21];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public Document parse(Element prototype) throws ParseException {
        Document doc = new Document(prototype);
        this.systemSpec(doc);
        return doc;
    }

    private void error(String str) {
        this.errors = this.errors == null ? str : this.errors + "\n" + str;
    }

    public String getErrors() {
        return this.errors;
    }

    private StringBuffer specialImage(Token t) {
        if (t != null) {
            return this.specialImage(t, t.image);
        }
        return new StringBuffer("");
    }

    private StringBuffer specialImage(Token t, String repl) {
        Stack<String> stack = new Stack<String>();
        StringBuffer s = new StringBuffer();
        stack.push(repl);
        t = t.specialToken;
        while (t != null) {
            stack.push(t.image);
            t = t.specialToken;
        }
        while (!stack.empty()) {
            s.append((String)stack.pop());
        }
        return s;
    }

    private StringBuffer skipTo(TerminationCondition condition, boolean leading) throws ParseException {
        StringBuffer s = new StringBuffer();
        while (!condition.terminate()) {
            Token t = this.getNextToken();
            if (t.kind != 0) {
                if (leading) {
                    s.append(this.specialImage(t.specialToken));
                } else {
                    leading = true;
                }
                s.append(t.image);
                continue;
            }
            if (condition.terminate()) break;
            throw new ParseException("Unexpected end of file.");
        }
        return s;
    }

    private String skipTo(int tokenKind, boolean leading) throws ParseException {
        StringBuffer s = new StringBuffer();
        Token t = this.getNextToken();
        while (t.kind != tokenKind) {
            if (t.kind == 0) {
                throw new ParseException("Token '" + tokenImage[tokenKind] + "'expected.");
            }
            if (leading) {
                s.append(this.specialImage(t.specialToken));
            } else {
                leading = true;
            }
            s.append(t.image);
            t = this.getNextToken();
        }
        return s.toString();
    }

    public final void systemSpec(Document document) throws ParseException {
        this.globalvardeclblock(document);
        while (this.getToken((int)1).kind == 5) {
            this.processdecl(document);
        }
        this.systemdeclblock(document);
    }

    void globalvardeclblock(Document document) throws ParseException {
        StringBuffer decl = this.skipTo(new TerminationCondition(){

            @Override
            public boolean terminate() {
                return XTAReader.this.getToken((int)1).kind == 24 || XTAReader.this.getToken((int)1).kind == 5;
            }
        }, true);
        if (decl.length() != 0) {
            document.setProperty("declaration", decl.toString());
        }
    }

    public final void processdecl(Document document) throws ParseException {
        Template template = document.createTemplate();
        this.PTHead(template);
        this.PTParamList(template);
        this.PTBody(template);
        document.insert(template, document.getLast());
    }

    void systemdeclblock(Document document) throws ParseException {
        document.setProperty("system", this.skipTo(0, false));
    }

    public final void PTHead(Template template) throws ParseException {
        String s;
        TerminationCondition tc = new TerminationCondition(){

            @Override
            public boolean terminate() {
                return XTAReader.this.getToken((int)1).kind == 29 || XTAReader.this.getToken((int)1).kind == 35;
            }
        };
        try {
            this.jj_consume_token(5);
            Token t = this.jj_consume_token(52);
            s = t.image;
        }
        catch (ParseException e) {
            s = new String(this.skipTo(tc, true));
        }
        template.setProperty("name", s);
    }

    public final void PTParamList(Template template) throws ParseException {
        String param = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                param = this.skipTo(30, true);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        template.setProperty("parameter", param);
    }

    public final void PTBody(Template template) throws ParseException {
        this.jj_consume_token(35);
        this.body(template);
        this.jj_consume_token(36);
    }

    public final void body(Template template) throws ParseException {
        HashMap locations = new HashMap();
        this.bodyLocal(template);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                this.bodyStates(template, locations);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                this.bodyBranches(template, locations);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.bodyCommitted(locations);
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block24;
                        }
                    }
                    this.jj_consume_token(33);
                    this.bodyCommitted(locations);
                }
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                this.bodyUrgent(locations);
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: {
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            break block25;
                        }
                    }
                    this.jj_consume_token(33);
                    this.bodyUrgent(locations);
                }
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                this.bodyInit(template, locations);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                this.bodyTransitions(template, locations);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
    }

    void bodyLocal(Template template) throws ParseException {
        StringBuffer decl = this.skipTo(new TerminationCondition(){
            int open = 0;

            @Override
            public boolean terminate() {
                Token t = XTAReader.this.getToken(1);
                if (t.kind == 35) {
                    ++this.open;
                } else if (t.kind == 36) {
                    --this.open;
                }
                return t.kind == 15 || this.open == -1;
            }
        }, false);
        if (decl.length() != 0) {
            template.setProperty("declaration", decl.toString());
        }
    }

    public final void bodyStates(Template template, Map locations) throws ParseException {
        this.bodyState(template, locations);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(33);
            this.bodyState(template, locations);
        }
        this.jj_consume_token(34);
    }

    public final void bodyBranches(Template template, Map locations) throws ParseException {
        this.bodyBranch(template, locations);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(33);
            this.bodyBranch(template, locations);
        }
        this.jj_consume_token(34);
    }

    public final void bodyState(Template template, Map locations) throws ParseException {
        Token t = this.jj_consume_token(52);
        Location location = template.createLocation();
        ((Element)location).setProperty("name", t.image);
        template.insert(location, template.getLast());
        locations.put(t.image, location);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                ((Element)location).setProperty("invariant", this.skipTo(36, false));
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                ((Element)location).setProperty("exponentialrate", this.skipTo(41, false));
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
    }

    public final void bodyBranch(Template template, Map locations) throws ParseException {
        Token t = this.jj_consume_token(52);
        BranchPoint branchPoint = template.createBranchPoint();
        branchPoint.setProperty("name", t.image);
        template.insert(branchPoint, template.getLast());
        locations.put(t.image, branchPoint);
    }

    public final void bodyCommitted(Map locations) throws ParseException {
        AbstractLocation loc = this.location(locations);
        if (loc != null) {
            loc.setProperty("committed", true);
        }
    }

    public final void bodyUrgent(Map locations) throws ParseException {
        AbstractLocation loc = this.location(locations);
        if (loc != null) {
            loc.setProperty("urgent", true);
        }
    }

    public final void bodyInit(Template template, Map locations) throws ParseException {
        AbstractLocation loc = this.location(locations);
        this.jj_consume_token(34);
        if (loc != null) {
            loc.setProperty("init", true);
        }
    }

    public final void bodyTransitions(Template template, Map locations) throws ParseException {
        AbstractLocation src = this.location(locations);
        boolean controllable = this.bodyTransitionSymbol();
        this.destination(template, locations, src, controllable);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(33);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 52: {
                    src = this.location(locations);
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                }
            }
            controllable = this.bodyTransitionSymbol();
            this.destination(template, locations, src, controllable);
        }
        this.jj_consume_token(34);
    }

    public final boolean bodyTransitionSymbol() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                this.jj_consume_token(45);
                return true;
            }
            case 46: {
                this.jj_consume_token(46);
                return false;
            }
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AbstractLocation location(Map locations) throws ParseException {
        Token t = this.jj_consume_token(52);
        AbstractLocation loc = (AbstractLocation)locations.get(t.image);
        if (loc == null) {
            this.error("Location " + t.image + " not found.");
        }
        return loc;
    }

    public final void destination(Template template, Map locations, AbstractLocation src, boolean controllable) throws ParseException {
        try {
            AbstractLocation dst = this.location(locations);
            Edge edge = template.createEdge();
            edge.setSource(src);
            edge.setTarget(dst);
            edge.setProperty("controllable", controllable);
            if (src != null && dst != null) {
                template.insert(edge, template.getLast());
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    this.jj_consume_token(35);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: {
                            this.jj_consume_token(19);
                            edge.setProperty("select", this.skipTo(34, false));
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 20: {
                            this.jj_consume_token(20);
                            edge.setProperty("guard", this.skipTo(34, false));
                            break;
                        }
                        default: {
                            this.jj_la1[17] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            this.jj_consume_token(21);
                            edge.setProperty("synchronisation", this.skipTo(34, false));
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 22: {
                            this.jj_consume_token(22);
                            edge.setProperty("assignment", this.skipTo(34, false));
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(36);
                    break;
                }
                case 40: {
                    this.jj_consume_token(40);
                    edge.setProperty("probability", this.skipTo(41, false));
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.skipTo(36, false);
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x20000000, 32768, 65536, 0, 262144, 0, 8192, 16384, 131072, 0, 0, 0, 0, 0, 0, 0, 524288, 0x100000, 0x200000, 0x400000, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 2, 0, 2, 0, 0, 0, 2, 2, 8, 256, 2, 0x100000, 24576, 0, 0, 0, 0, 264};
    }

    public XTAReader(InputStream stream) {
        this(stream, null);
    }

    public XTAReader(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new XTAReaderTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public XTAReader(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new XTAReaderTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public XTAReader(XTAReaderTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(XTAReaderTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[55];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 21; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 55; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        XTAReader.jj_la1_init_0();
        XTAReader.jj_la1_init_1();
    }

    static interface TerminationCondition {
        public boolean terminate();
    }
}

