/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.Problem;
import com.uppaal.engine.Protocol;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.engine.ServerException;
import com.uppaal.model.core2.Document;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.GanttChart;
import com.uppaal.model.system.IdentifierTranslator;
import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteSuccessor;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class KeyValueProtocol
implements Protocol {
    private BufferedWriter out;
    private BufferedReader in;

    public KeyValueProtocol(InputStream in, OutputStream out) {
        try {
            this.in = new BufferedReader(new InputStreamReader(in, "utf-8"));
            this.out = new BufferedWriter(new OutputStreamWriter(out, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.in = new BufferedReader(new InputStreamReader(in));
            this.out = new BufferedWriter(new OutputStreamWriter(out));
        }
    }

    @Override
    public void close() throws IOException {
        this.sendMessage(Service.QUIT);
    }

    public SystemState getInitial(UppaalSystem system) throws EngineException, IOException {
        this.sendMessage(Service.GET_INITIAL_STATE);
        List<Properties> prop = this.recvProperties(Service.GET_INITIAL_STATE);
        return this.parseState(prop.get(0), system, "locations", "variables", "zone");
    }

    protected SystemLocation[] parseLocationVector(String property, UppaalSystem system) {
        String[] locationsStr = property.split("\\s+");
        SystemLocation[] locations = new SystemLocation[system.getNoOfProcesses()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = system.getLocation(i, Integer.parseInt(locationsStr[i]));
        }
        return locations;
    }

    protected int[] parseVariableVector(String property, UppaalSystem system) {
        String[] variablesStr = property.split("\\s+");
        int[] variables = new int[system.getNoOfVariables()];
        for (int i = 0; i < variables.length; ++i) {
            variables[i] = Integer.parseInt(variablesStr[i]);
        }
        return variables;
    }

    protected Polyhedron parseZone(String property, UppaalSystem system) {
        Polyhedron zone = new Polyhedron(system);
        if (!property.equals("")) {
            String[] zoneStr = property.split("\\s+");
            for (int idx = 0; idx < zoneStr.length; idx += 3) {
                int i = Integer.parseInt(zoneStr[idx]);
                int j = Integer.parseInt(zoneStr[idx + 1]);
                int b = Integer.parseInt(zoneStr[idx + 2]);
                zone.add(i, j, b ^ 1);
            }
            zone.trim();
        }
        return zone;
    }

    @Override
    public String getOptionsInfo() throws EngineException, IOException {
        this.sendMessage(Service.GET_OPTIONS_INFO);
        return this.recvString(Service.GET_OPTIONS_INFO);
    }

    @Override
    public ArrayList<SymbolicTransition> getTransitions(UppaalSystem system, SymbolicState state) throws EngineException, IOException {
        this.sendMessage(Service.GET_TRANSITIONS, state);
        List<Properties> prop = this.recvProperties(Service.GET_TRANSITIONS);
        ArrayList<SymbolicTransition> succs = new ArrayList<SymbolicTransition>();
        for (Properties properties : prop) {
            SymbolicState src;
            String transitiontype = properties.getProperty("transitiontype");
            if (transitiontype.equals("normal")) {
                src = this.parseState(properties, system, "src_locations", "src_variables", "src_zone");
                SymbolicState dst = this.parseState(properties, system, "dst_locations", "dst_variables", "dst_zone");
                SystemEdgeSelect[] e = this.parseEdges(properties, system, "edges");
                String edgeDescr = properties.getProperty("edgedescription");
                succs.add(new SymbolicTransition(src, e, dst, edgeDescr));
                continue;
            }
            if (transitiontype.equals("deadlock")) {
                src = this.parseState(properties, system, "src_locations", "src_variables", "src_zone");
                String edgeDescr = properties.getProperty("edgedescription");
                succs.add(new SymbolicTransition(src, new SystemEdgeSelect[0], null, edgeDescr));
                continue;
            }
            if (transitiontype.equals("invariant_fail")) {
                src = this.parseState(properties, system, "src_locations", "src_variables", "src_zone");
                SystemEdgeSelect[] e = this.parseEdges(properties, system, "edges");
                String edgeDescr = properties.getProperty("edgedescription");
                succs.add(new SymbolicTransition(src, e, null, edgeDescr));
                continue;
            }
            if (transitiontype.equals("error")) {
                return null;
            }
            throw new ProtocolException("Bug: Unknown transition type: " + transitiontype);
        }
        return succs;
    }

    protected SymbolicState parseState(Properties data, UppaalSystem system, String locations, String variables, String zone) {
        return new SymbolicState(this.parseLocationVector(data.getProperty(locations).trim(), system), this.parseVariableVector(data.getProperty(variables).trim(), system), this.parseZone(data.getProperty(zone).trim(), system));
    }

    protected SystemEdgeSelect[] parseEdges(Properties data, UppaalSystem system, String edges) {
        String[] ids;
        LinkedList<SystemEdgeSelect> edgesList = new LinkedList<SystemEdgeSelect>();
        for (String str : ids = data.getProperty(edges).split("\\s+")) {
            String[] values = str.split(":");
            edgesList.add(system.createEdgeCon(Integer.parseInt(values[0]), Integer.parseInt(values[1]), null));
        }
        return edgesList.toArray(new SystemEdgeSelect[0]);
    }

    @Override
    public String getVersion() throws IOException, EngineException {
        this.sendMessage(Service.UPPAAL_VERSION);
        return this.recvString(Service.UPPAAL_VERSION);
    }

    @Override
    public char query(UppaalSystem system, String query, QueryFeedback f) throws EngineException, IOException {
        String probability;
        Properties systemInfo;
        List<Properties> prop;
        this.sendMessage(Service.GET_SYSTEM_INFO);
        try {
            prop = this.recvProperties(Service.GET_SYSTEM_INFO);
            systemInfo = prop.get(0);
            f.setProgressAvail(true);
            this.setSystemInfo(f, systemInfo);
        }
        catch (ServerException e) {
            f.setProgressAvail(false);
        }
        this.sendMessage(Service.MODELCHECK, query);
        prop = this.recvProperties(Service.MODELCHECK, true);
        while (prop.get(0).getProperty("result") == null) {
            systemInfo = prop.get(0);
            this.setProgress(f, systemInfo);
            prop = this.recvProperties(Service.MODELCHECK, true);
        }
        Properties resultData = prop.get(0);
        String statustext = resultData.getProperty("statustext");
        if (statustext != null) {
            f.appendText(statustext);
        }
        if ((probability = resultData.getProperty("probability")) != null) {
            f.setResultText(probability);
        }
        char result = resultData.getProperty("result").charAt(0);
        int cycle = Integer.parseInt(resultData.getProperty("cycle", "0"));
        List<Properties> traceData = prop.subList(1, prop.size());
        if (traceData.size() > 0) {
            f.setLength(traceData.size());
            ArrayList<SymbolicTransition> trace = new ArrayList<SymbolicTransition>();
            SymbolicState src = this.parseState(traceData.get(0), system, "locations", "variables", "zone");
            trace.add(new SymbolicTransition(null, null, src));
            for (int current = 1; current < traceData.size(); ++current) {
                Properties data = traceData.get(current);
                SymbolicState dst = this.parseState(data, system, "locations", "variables", "zone");
                SystemEdgeSelect[] edges = this.parseEdges(data, system, "edges");
                trace.add(new SymbolicTransition(src, edges, dst));
                src = dst;
                f.setCurrent(current - 1);
            }
            f.setTrace(result, null, trace, cycle);
        }
        return result;
    }

    protected void setProgress(QueryFeedback f, Properties data) {
        f.setProgress(Integer.parseInt(data.getProperty("load")), Integer.parseInt(data.getProperty("vm")), Integer.parseInt(data.getProperty("rss")), Integer.parseInt(data.getProperty("cached")), Integer.parseInt(data.getProperty("avail")), Integer.parseInt(data.getProperty("swap")), Integer.parseInt(data.getProperty("swapfree")), Integer.parseInt(data.getProperty("user")), Integer.parseInt(data.getProperty("sys")), 0L);
    }

    protected void setSystemInfo(QueryFeedback f, Properties data) {
        f.setSystemInfo(Integer.parseInt(data.getProperty("vmsize")), Integer.parseInt(data.getProperty("physsize")), Integer.parseInt(data.getProperty("swapsize")));
    }

    @Override
    public void setOptions(String options) throws EngineException, IOException {
        this.sendMessage(Service.SET_OPTIONS, options);
        this.recvString(Service.SET_OPTIONS);
    }

    @Override
    public UppaalSystem upload(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        StringWriter xmlStr = new StringWriter();
        try {
            int i;
            document.accept(new XMLWriter(xmlStr));
            this.sendMessage(Service.NEW_XML_SYSTEM, xmlStr.toString());
            List<Properties> result = this.recvProperties(Service.NEW_XML_SYSTEM);
            for (i = 0; i < result.size() && result.get(i).getProperty("path") != null; ++i) {
                problems.add(this.parseProblem(result.get(i)));
            }
            if (i < result.size()) {
                Properties system = result.get(i);
                List<Properties> processesData = result.subList(i + 1, result.size());
                if (system.getProperty("system_status", "error").equals("ok")) {
                    return this.parseSystem(system, processesData, document);
                }
                return null;
            }
            return null;
        }
        catch (EngineException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineException(e);
        }
    }

    private UppaalSystem parseSystem(Properties data, List<Properties> processesData, Document document) {
        String varString = data.getProperty("variables").trim();
        ArrayList<String> vars = !varString.equals("") ? new ArrayList<String>(Arrays.asList(varString.split("\\s+"))) : new ArrayList();
        ArrayList<String> clocks = new ArrayList<String>(Arrays.asList(data.getProperty("clocks").split("\\s+")));
        UppaalSystem system = new UppaalSystem(document);
        system.setVariables(vars);
        system.setClocks(clocks);
        for (Properties process : processesData) {
            String name = process.getProperty("name").trim();
            String templateName = process.getProperty("template").trim();
            String parameters = process.getProperty("parameters", "").trim();
            HashMap<String, String> map = new HashMap<String, String>();
            if (!parameters.equals("")) {
                for (String str : parameters.split("\\s+")) {
                    String[] values = str.split(":");
                    map.put(values[0], values[1]);
                }
            }
            system.addProcess(name, templateName, new IdentifierTranslator(map));
        }
        return system;
    }

    private Problem parseProblem(Properties data) {
        String type = data.getProperty("type");
        String path = data.getProperty("path");
        int fline = Integer.parseInt(data.getProperty("fline"));
        int fcolumn = Integer.parseInt(data.getProperty("fcolumn"));
        int lline = Integer.parseInt(data.getProperty("lline"));
        int lcolumn = Integer.parseInt(data.getProperty("lcolumn"));
        String msg = data.getProperty("msg");
        return new Problem(type, path, fline, fcolumn, lline, lcolumn, msg);
    }

    @Override
    public UppaalSystem upload(Document document) throws EngineException, IOException {
        ArrayList<Problem> tmp = new ArrayList<Problem>();
        return this.upload(document, tmp);
    }

    protected void sendMessage(Service service) throws IOException {
        this.out.write(service.toString());
        this.out.write("\n.\n");
        this.out.flush();
    }

    protected void sendMessage(Service service, String data) throws IOException {
        this.out.write(service.toString());
        this.out.write(10);
        this.out.write(this.escape(data));
        this.out.write(".\n");
        this.out.flush();
    }

    protected void sendMessage(Service service, SymbolicState state) throws IOException {
        Properties data = new Properties();
        StringBuilder sb = new StringBuilder();
        for (SystemLocation loc : state.getLocations()) {
            sb.append(loc.getIndex()).append(' ');
        }
        data.setProperty("locations", sb.toString().trim());
        sb = new StringBuilder();
        for (int val : state.getVariables()) {
            sb.append(val).append(' ');
        }
        data.setProperty("variables", sb.toString().trim());
        data.setProperty("zone", state.getPolyhedron().toString());
        StringWriter stringWriter = new StringWriter();
        data.store(stringWriter, "");
        this.sendMessage(service, stringWriter.toString());
    }

    protected String localiseString(String str) {
        return str;
    }

    protected List<Properties> recvProperties(Service serviceName) throws IOException, EngineException {
        return this.recvProperties(serviceName, false);
    }

    protected List<Properties> recvProperties(Service serviceName, boolean allow_progress) throws IOException, EngineException {
        String[] parts;
        LinkedList<Properties> result = new LinkedList<Properties>();
        String block = this.recvBlock(serviceName, allow_progress);
        for (String part : parts = block.split("(?m)^\\*+$")) {
            Properties prop = new Properties();
            prop.load(new StringReader(part));
            result.add(prop);
        }
        return result;
    }

    protected String recvString(Service serviceName) throws IOException, EngineException {
        return this.localiseString(this.recvBlock(serviceName, false));
    }

    protected String recvBlock(Service serviceName, boolean allow_progress) throws IOException, EngineException {
        List<String> lines = this.recvLines(serviceName, allow_progress);
        StringBuilder block = new StringBuilder();
        for (String line : lines) {
            block.append(line).append('\n');
        }
        return block.toString();
    }

    protected List<String> recvLines(Service serviceName, boolean allow_progress) throws IOException, EngineException {
        List<String> lines = this.readLines();
        if (lines.size() < 1) {
            throw new ProtocolException("Bug: Malformed message; no header.");
        }
        List<String> dataLines = lines.subList(1, lines.size());
        String[] header = lines.get(0).split("\\s+");
        if (header.length != 2) {
            throw new ProtocolException("Bug: Malformed message header: " + lines.get(0));
        }
        if (!header[0].equals(serviceName.toString())) {
            throw new ProtocolException("Bug: Wrong reply type; expected: " + (Object)((Object)serviceName) + " but got: " + header[0]);
        }
        if (header[1].equals("ERROR")) {
            StringBuilder err = new StringBuilder();
            for (String line : dataLines) {
                err.append(line);
            }
            throw new ServerException(this.localiseString(err.toString()));
        }
        if (allow_progress && header[1].equals("PROGRESS")) {
            return dataLines;
        }
        if (!header[1].equals("OK")) {
            throw new ProtocolException("Bug: OK expected, but got: " + header[1]);
        }
        return dataLines;
    }

    protected List<String> readLines() throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        String line = this.in.readLine();
        while (!line.equals(".")) {
            if (line.startsWith(".")) {
                lines.add(line.substring(1));
            } else {
                lines.add(line);
            }
            line = this.in.readLine();
        }
        return lines;
    }

    protected String escape(String str) {
        String[] lines = str.split("(?:\\n\\r)|\\n|\\r");
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith(".")) {
                result.append('.');
            }
            result.append(line);
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    public LscProcess uploadLsc(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        return null;
    }

    @Override
    public synchronized GanttChart getGanttChart(UppaalSystem system, BigDecimal globalTime) throws EngineException, IOException {
        return new GanttChart();
    }

    @Override
    public ConcreteSuccessor getConcreteSuccessor(UppaalSystem system, ConcreteState state, SystemEdgeSelect[] edges, BigDecimal currentTime, BigDecimal delay) throws EngineException, IOException {
        return new ConcreteSuccessor(state, null);
    }

    @Override
    public ConcreteState getConcreteInitial(UppaalSystem system) throws EngineException, IOException {
        return new ConcreteState(null, null, null);
    }

    @Override
    public SymbolicState getSymbolicInitial(UppaalSystem system) throws EngineException, IOException {
        return new SymbolicState(null, null, null);
    }

    protected static enum Service {
        GET_INITIAL_STATE,
        GET_OPTIONS_INFO,
        GET_SYSTEM_INFO,
        GET_TRANSITIONS,
        MODELCHECK,
        NEW_XML_SYSTEM,
        QUIT,
        UPPAAL_VERSION,
        SET_OPTIONS;

    }
}

