/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.concrete.Limit;
import java.math.BigDecimal;

public class GanttBar
implements Cloneable {
    public Limit fromTime;
    public Limit toTime;
    public int value;
    public int xStart;
    public int xStop;
    public int yStart;
    public int yStop;
    public boolean overlaps;

    public GanttBar() {
        this.fromTime = new Limit();
        this.toTime = new Limit();
        this.overlaps = false;
    }

    public GanttBar(Limit from, Limit to, BigDecimal globaltime, int val) {
        if (to.isStrictLowerBoundOf(from.getValue())) {
            throw new IllegalArgumentException("Gantt bar cannot have end time before or equal to start time");
        }
        this.fromTime = from.add(globaltime);
        this.toTime = to.add(globaltime);
        this.overlaps = false;
        this.xStart = 0;
        this.xStop = 0;
        this.yStart = 0;
        this.yStop = 0;
        this.value = val;
    }

    public String toString() {
        String bracket1 = "(";
        String bracket2 = ")";
        String val1 = "infinity";
        String val2 = "infinity";
        if (this.fromTime.isStrict() && !this.fromTime.isUnbounded()) {
            bracket1 = "[";
        }
        if (this.toTime.isStrict() && !this.toTime.isUnbounded()) {
            bracket2 = "]";
        }
        if (!this.fromTime.isUnbounded()) {
            val1 = Double.toString(this.fromTime.getDoubleValue());
        }
        if (!this.toTime.isUnbounded()) {
            val2 = Double.toString(this.toTime.getDoubleValue());
        }
        return "Value " + this.value + " in interval " + bracket1 + val1 + ", " + val2 + bracket2;
    }

    public boolean insideBar(int x, int y) {
        return y >= this.yStart && y <= this.yStop && x >= this.xStart && (this.toTime.isUnbounded() || x <= this.xStop);
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        GanttBar theClone = new GanttBar();
        theClone.value = this.value;
        theClone.fromTime = this.fromTime == null ? null : (Limit)this.fromTime.clone();
        theClone.toTime = this.toTime == null ? null : (Limit)this.toTime.clone();
        theClone.xStart = this.xStart;
        theClone.yStart = this.yStart;
        theClone.xStop = this.xStop;
        theClone.yStop = this.yStop;
        theClone.overlaps = this.overlaps;
        return theClone;
    }
}

