/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.Parser;
import com.uppaal.engine.Problem;
import com.uppaal.engine.Protocol;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.engine.ServerException;
import com.uppaal.model.core2.Document;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.GanttChart;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteSuccessor;
import com.uppaal.model.system.concrete.ConcreteVariable;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class DotProtocol
implements Protocol {
    private BufferedWriter out;
    private InputStream in;
    private Parser parser;

    public DotProtocol(InputStream in, OutputStream out) {
        this.in = in;
        this.parser = new Parser(this.in);
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(out, "utf-8"));
        }
        catch (Exception e) {
            this.out = new BufferedWriter(new OutputStreamWriter(out));
        }
    }

    @Override
    public void close() throws IOException {
        this.write("quit");
        this.flush();
    }

    @Override
    public SymbolicState getSymbolicInitial(UppaalSystem system) throws EngineException, IOException {
        this.write("getInitialState");
        this.flush();
        return this.parser.parseSymbolicInitial(system);
    }

    @Override
    public ConcreteState getConcreteInitial(UppaalSystem system) throws EngineException, IOException {
        this.write("concreteGetInitial");
        this.flush();
        return this.parser.parseConcreteInitial(system);
    }

    @Override
    public ConcreteSuccessor getConcreteSuccessor(UppaalSystem system, ConcreteState state, SystemEdgeSelect[] edges, BigDecimal currentTime, BigDecimal delay) throws EngineException, IOException {
        this.write("concreteGetSuccessor");
        this.write(currentTime.add(delay));
        this.write(state, delay);
        this.write(edges);
        this.write(".");
        this.flush();
        return this.parser.parseConcreteSuccessor(system);
    }

    @Override
    public String getOptionsInfo() throws EngineException, IOException {
        this.write("getOptionsInfo");
        this.flush();
        return this.parser.parseBlock();
    }

    @Override
    public ArrayList<SymbolicTransition> getTransitions(UppaalSystem system, SymbolicState state) throws EngineException, IOException {
        this.write("getTransitions");
        this.write(state);
        this.flush();
        return this.parser.parseEnabledTransitions(system);
    }

    @Override
    public String getVersion() throws IOException, EngineException {
        this.write("version");
        this.flush();
        return this.parser.parseBlock();
    }

    @Override
    public char query(UppaalSystem system, String query, QueryFeedback f) throws EngineException, IOException {
        this.write("getSystemInfo");
        this.flush();
        String response = this.parser.parseId();
        if ("ok".equals(response)) {
            f.setProgressAvail(true);
            f.setSystemInfo(this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger());
            this.parser.parseEnd();
        } else if ("error".equals(response)) {
            this.parser.readBlock();
            f.setProgressAvail(false);
        }
        this.write("modelCheck");
        this.write(query);
        this.write(".");
        this.flush();
        return this.processQueryFeedback(system, f);
    }

    public char query(UppaalSystem system, SymbolicState state, String query, QueryFeedback f) throws EngineException, IOException {
        this.write("getSystemInfo");
        this.flush();
        String response = this.parser.parseId();
        if ("ok".equals(response)) {
            f.setProgressAvail(true);
            f.setSystemInfo(this.parser.parseInteger(), this.parser.parseInteger(), this.parser.parseInteger());
            this.parser.parseEnd();
        } else if ("error".equals(response)) {
            this.parser.readBlock();
            f.setProgressAvail(false);
        }
        this.write("modelCheckFromState");
        this.write(state);
        this.write(query);
        this.write(".");
        this.flush();
        return this.processQueryFeedback(system, f);
    }

    private char processQueryFeedback(UppaalSystem system, QueryFeedback f) throws EngineException, IOException {
        String response;
        while ("progress".equals(response = this.parser.parseId())) {
            f.setProgress(this.parser.parseInteger(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong(), this.parser.parseLong());
            this.parser.parseEnd();
        }
        if ("error".equals(response)) {
            throw new ServerException(this.parser.readBlock());
        }
        if (!"ok".equals(response)) {
            throw new ProtocolException("Ok expected");
        }
        char result = this.parser.parseId().charAt(0);
        String feedback = this.parser.readBlock();
        int length = this.parser.parseInteger();
        int cycle = this.parser.parseInteger();
        if (length >= 0) {
            f.setLength(length);
            ArrayList<SymbolicTransition> trace = new ArrayList<SymbolicTransition>();
            SymbolicState src = this.parser.parseSymbolicState(system);
            trace.add(new SymbolicTransition(null, null, src, null));
            for (int current = 0; current < length; ++current) {
                SystemEdgeSelect[] edges = this.parser.parseEdgesWS(system);
                SymbolicState dst = this.parser.parseSymbolicState(system);
                trace.add(new SymbolicTransition(src, edges, dst, null));
                src = dst;
                f.setCurrent(current);
            }
            f.setTrace(result, feedback, trace, cycle);
            this.parser.parseEnd();
        } else {
            f.setFeedback(feedback);
        }
        return result;
    }

    @Override
    public void setOptions(String options) throws EngineException, IOException {
        this.write("setOptions");
        this.write(options);
        this.write(".");
        this.flush();
        this.parser.parseAcknowledgement();
    }

    @Override
    public UppaalSystem upload(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        try {
            this.write("newXMLSystem3");
            document.accept(new XMLWriter(this.out));
            this.write("\n");
            this.write(".");
            this.flush();
            this.parser.parseProblems(problems);
            if (this.parser.parseInteger() == 1) {
                return this.parser.parseSystem(document);
            }
            return null;
        }
        catch (EngineException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineException(e.toString());
        }
    }

    @Override
    public UppaalSystem upload(Document document) throws EngineException, IOException {
        try {
            this.write("newXMLSystem3");
            document.accept(new XMLWriter(this.out));
            this.write("\n");
            this.write(".");
            this.flush();
            this.parser.skipProblems();
            if (this.parser.parseInteger() == 1) {
                return this.parser.parseSystem(document);
            }
            return null;
        }
        catch (EngineException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineException(e.toString());
        }
    }

    protected void write(String s) throws IOException {
        this.out.write(s);
        this.out.write(10);
    }

    protected void write(Object o) throws IOException {
        this.out.write(o.toString());
        this.out.write(10);
    }

    private void write(SymbolicState state) throws IOException {
        state.writeServerFormat(this.out);
        this.out.write(10);
    }

    protected void write(BigDecimal value) throws IOException {
        this.out.write(value.toPlainString());
        this.out.write(10);
    }

    protected void write(ConcreteState state, BigDecimal delay) throws IOException {
        SystemLocation[] locations = state.getLocations();
        ConcreteVariable[] variables = state.getCVariables();
        this.write(locations.length);
        for (SystemLocation location : locations) {
            this.write(location.getIndex());
        }
        this.write(variables.length);
        for (ConcreteVariable variable : variables) {
            this.write(variable.getValue(delay));
        }
    }

    protected void write(SystemEdge[] edges) throws IOException {
        this.write(edges.length);
        for (SystemEdge edge : edges) {
            this.write("" + edge.getProcess().getIndex() + " " + edge.getIndex());
        }
    }

    protected void write(SystemEdgeSelect[] edges) throws IOException {
        this.write(edges.length);
        for (SystemEdgeSelect edge : edges) {
            this.write("" + edge.getProcess().getIndex() + " " + edge.getIndex());
            List<Integer> listvalues = edge.getSelectList();
            this.write(listvalues.size());
            for (Integer i : listvalues) {
                this.write("" + i + " ");
            }
        }
    }

    protected void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public LscProcess uploadLsc(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        return null;
    }

    @Override
    public synchronized GanttChart getGanttChart(UppaalSystem system, BigDecimal globalTime) throws EngineException, IOException {
        return this.parser.parseGanttChart(system, globalTime);
    }
}

