/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.gdi.BitmapInfoHeader;
import org.freehep.graphicsio.emf.gdi.BlendFunction;

public class EMFImageLoader {
    public static BufferedImage readImage(BitmapInfoHeader bmi, int width, int height, EMFInputStream emf, int len, BlendFunction blendFunction) throws IOException {
        if (bmi.getBitCount() == 1) {
            int blue = emf.readUnsignedByte();
            int green = emf.readUnsignedByte();
            int red = emf.readUnsignedByte();
            emf.readUnsignedByte();
            int color1 = new Color(red, green, blue).getRGB();
            blue = emf.readUnsignedByte();
            green = emf.readUnsignedByte();
            red = emf.readUnsignedByte();
            emf.readUnsignedByte();
            int color2 = new Color(red, green, blue).getRGB();
            BufferedImage result = new BufferedImage(width, height, 1);
            int[] data = emf.readUnsignedByte(len - 8);
            int strangeOffset = width % 8;
            if (strangeOffset != 0) {
                strangeOffset = 8 - strangeOffset;
            }
            int pixel = 0;
            int[] mask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
            for (int y = height - 1; y > -1; --y) {
                for (int x = 0; x < width; ++x) {
                    int pixelDataGroup = data[pixel / 8];
                    int pixelData = pixelDataGroup & mask[pixel % 8];
                    ++pixel;
                    if (pixelData > 0) {
                        result.setRGB(x, y, color2);
                        continue;
                    }
                    result.setRGB(x, y, color1);
                }
                pixel += strangeOffset;
            }
            return result;
        }
        if (bmi.getBitCount() == 8 && bmi.getCompression() == 0) {
            int strangeOffset;
            int colorsUsed = bmi.getClrUsed();
            int[] colors = emf.readUnsignedByte(colorsUsed * 4);
            int[] data = emf.readUnsignedByte(len - colorsUsed * 4);
            int[] colorTable = new int[256];
            int color = 0;
            int i = 0;
            while (i < colorsUsed) {
                colorTable[i] = new Color(colors[color + 2], colors[color + 1], colors[color]).getRGB();
                color = ++i * 4;
            }
            if (colorsUsed < 256) {
                Arrays.fill(colorTable, colorsUsed, 256, 0);
            }
            if ((strangeOffset = width % 4) != 0) {
                strangeOffset = 4 - strangeOffset;
            }
            BufferedImage result = new BufferedImage(width, height, 1);
            int pixel = 0;
            for (int y = height - 1; y > -1; --y) {
                for (int x = 0; x < width; ++x) {
                    result.setRGB(x, y, colorTable[data[pixel++]]);
                }
                pixel += strangeOffset;
            }
            return result;
        }
        if (bmi.getBitCount() == 16 && bmi.getCompression() == 0) {
            int[] data = emf.readDWORD(len / 4);
            width = (width + width % 2) / 2;
            height = data.length / width / 2;
            BufferedImage result = new BufferedImage(width, height, 1);
            int off = 0;
            int y = height - 1;
            while (y > -1) {
                for (int x = 0; x < width; ++x) {
                    int neighbor = data[off + width];
                    int pixel = data[off++];
                    result.setRGB(x, y, new Color((float)((pixel & 0x7C00) + (neighbor & 0x7C00)) / 63488.0f, (float)((pixel & 0x3E0) + (neighbor & 0x3E0)) / 1984.0f, (float)((pixel & 0x1F) + (neighbor & 0x1F)) / 62.0f).getRGB());
                }
                --y;
                off += width;
            }
            return result;
        }
        if (bmi.getBitCount() == 32 && bmi.getCompression() == 0) {
            width = (width + width % 20) / 20;
            height = (height + height % 20) / 20;
            BufferedImage result = new BufferedImage(width, height, 2);
            int[] data = emf.readDWORD(len / 4);
            int off = 0;
            int sourceConstantAlpha = blendFunction.getSourceConstantAlpha();
            if (blendFunction.getAlphaFormat() != 1) {
                for (int y = height - 1; y > -1 && off < data.length; --y) {
                    for (int x = 0; x < width && off < data.length; ++x) {
                        int pixel = data[off++];
                        result.setRGB(x, y, new Color((pixel & 0xFF0000) >> 16, (pixel & 0xFF00) >> 8, pixel & 0xFF, sourceConstantAlpha).getRGB());
                    }
                }
            } else if (sourceConstantAlpha == 255) {
                for (int y = height - 1; y > -1 && off < data.length; --y) {
                    for (int x = 0; x < width && off < data.length; ++x) {
                        int pixel;
                        int alpha;
                        if ((alpha = ((pixel = data[off++]) & 0xFF000000) >> 24) == -1) {
                            alpha = 255;
                        }
                        result.setRGB(x, y, new Color((pixel & 0xFF0000) >> 16, (pixel & 0xFF00) >> 8, pixel & 0xFF, alpha).getRGB());
                    }
                }
            } else {
                for (int y = height - 1; y > -1 && off < data.length; --y) {
                    for (int x = 0; x < width && off < data.length; ++x) {
                        int pixel;
                        int alpha;
                        if ((alpha = ((pixel = data[off++]) & 0xFF000000) >> 24) == -1) {
                            alpha = 255;
                        }
                        alpha = alpha * sourceConstantAlpha / 255;
                        result.setRGB(x, y, new Color((pixel & 0xFF0000) >> 16, (pixel & 0xFF00) >> 8, pixel & 0xFF, alpha).getRGB());
                    }
                }
            }
            return result;
        }
        if (bmi.getBitCount() == 32 && bmi.getCompression() == 3) {
            emf.readByte(len);
            return null;
        }
        emf.readByte(len);
        return null;
    }
}

