/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.GanttRow;
import com.uppaal.model.system.concrete.Limit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GanttChart
implements Cloneable {
    private List<GanttRow> chart = new ArrayList<GanttRow>();

    public void addRow(GanttRow r) {
        this.chart.add(r);
    }

    public int noOfRows() {
        return this.chart.size();
    }

    public GanttRow getRow(int i) {
        return this.chart.get(i);
    }

    public void truncate(BigDecimal t) {
        for (GanttRow r : this.chart) {
            r.truncate(t);
        }
    }

    public void truncate(int from) {
        this.truncate(new BigDecimal(from));
    }

    public void clearChart() {
        Iterator<GanttRow> i = this.chart.iterator();
        while (i.hasNext()) {
            i.next().clearRow();
        }
    }

    public Limit maximalNonInfiniteEndTime() {
        Limit tmp = new Limit(new BigDecimal(0), true);
        boolean flagInfinite = true;
        for (GanttRow r : this.chart) {
            if (r.maximalEndTime().isUnbounded() || !r.maximalEndTime().isUpperBoundOf(tmp.getValue())) continue;
            tmp = r.maximalEndTime();
            flagInfinite = false;
        }
        if (flagInfinite) {
            tmp.setValue(null);
        }
        return tmp;
    }

    public void printGanttInfo() {
        System.out.println();
        System.out.println("Gantt bar dump");
        System.out.println("Number of rows: " + this.chart.size());
        System.out.println();
        for (int i = 0; i < this.chart.size(); ++i) {
            System.out.print("Row: " + i + " ");
            this.chart.get(i).printRowInfo();
        }
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        GanttChart theClone = new GanttChart();
        for (int i = 0; i < this.chart.size(); ++i) {
            theClone.addRow((GanttRow)this.chart.get(i).clone());
        }
        return theClone;
    }
}

