/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractLocation;
import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import java.util.HashMap;

public class Template
extends AbstractTemplate {
    public Template(Element prototype) {
        super(prototype);
    }

    public Location createLocation() {
        return new Location((Element)this.getPropertyValue("#location"));
    }

    public BranchPoint createBranchPoint() {
        return new BranchPoint((Element)this.getPropertyValue("#branchpoint"));
    }

    public Edge createEdge() {
        return new Edge((Element)this.getPropertyValue("#edge"));
    }

    @Override
    public Element getPrototypeFromParent(Element parent) {
        return (Element)parent.getPropertyValue("#template");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Template template = (Template)super.clone();
        final HashMap<Node, Node> mapping = new HashMap<Node, Node>();
        Node p = this.first;
        Node q = template.first;
        while (p != null) {
            assert (q != null);
            mapping.put(p, q);
            p = p.getNext();
            q = q.getNext();
        }
        template.acceptSafe(new AbstractVisitor(){

            @Override
            public void visitEdge(Edge edge) {
                edge.source = (AbstractLocation)mapping.get(edge.source);
                edge.target = (AbstractLocation)mapping.get(edge.target);
            }
        });
        return template;
    }
}

