/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.ProtocolException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ResourceBundle;

public class LexicalAnalyser {
    public static final int NEWLINE = 0;
    public static final int END = 1;
    public static final int WORD = 2;
    public static final int BLOCK = 3;
    public static final int INT = 4;
    public static final int FLOAT = 7;
    public static final int LONG = 5;
    public static final int NONE = 6;
    public static final int PARTIAL_END = 8;
    public static final int PARTIAL_BIS_END = 9;
    public static final int ERROR_EOL = 10;
    private static final char EOS = '\u0000';
    private static final char NL = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final char DOT = '.';
    private static final char SEMICOLON = ';';
    private static final char COLON = ':';
    private static String word;
    private int lookahead;
    private char peak;
    private char[] cb = new char[256];
    private char[] bb = new char[2048];
    private int offset = 0;
    private int bytes = 0;
    private static ResourceBundle locale;
    private InputStreamReader in;

    public LexicalAnalyser(InputStream r) {
        try {
            this.in = new InputStreamReader(r, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.in = new InputStreamReader(r);
        }
        this.peak = (char)32;
        this.lookahead = 6;
    }

    public int getLookahead() throws IOException {
        if (this.lookahead == 6) {
            this.lookahead = this.nextToken();
        }
        return this.lookahead;
    }

    public String getWord() {
        return word;
    }

    public int getIntValue() {
        return Integer.valueOf(word);
    }

    public long getValue() {
        return Long.valueOf(word);
    }

    public BigDecimal getFloat() {
        return new BigDecimal(word);
    }

    private void fill() throws IOException {
        this.bytes = this.in.read(this.bb, 0, this.bb.length);
        this.offset = 0;
    }

    public String readBlock() throws IOException {
        assert (this.lookahead == 6);
        StringBuffer s = new StringBuffer();
        while (Character.isWhitespace(this.peak)) {
            this.peak = this.read();
        }
        while (true) {
            if (this.peak == '.') {
                this.peak = this.read();
                if (this.peak != '.') break;
            }
            s.append(this.peak);
            this.peak = this.read();
        }
        int pos = 0;
        while ((pos = s.indexOf("$", pos)) >= 0) {
            int end;
            int max = s.length();
            block8: for (end = pos + 1; end < max; ++end) {
                switch (s.charAt(end)) {
                    case '\u0000': 
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ':': {
                        break block8;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            try {
                String v = locale.getString(s.substring(pos + 1, end));
                s.replace(pos, end, v);
                pos += v.length();
            }
            catch (Exception e) {
                ++pos;
            }
        }
        word = s.toString();
        return word;
    }

    public char read() throws IOException {
        char c;
        do {
            if (this.offset != this.bytes) continue;
            this.fill();
            if (this.bytes != -1) continue;
            return '\u0000';
        } while ((c = this.bb[this.offset++]) == '\r');
        return c;
    }

    public int nextToken() throws IOException {
        if (this.lookahead != 6) {
            int token = this.lookahead;
            this.lookahead = 6;
            return token;
        }
        int sign = 1;
        int i = 0;
        while (Character.isWhitespace(this.peak)) {
            this.peak = this.read();
        }
        switch (this.peak) {
            case '\u0000': {
                throw new IOException("Server connection lost");
            }
            case '.': {
                this.peak = this.read();
                if (Character.isWhitespace(this.peak)) {
                    return 1;
                }
                this.cb[i++] = 46;
                break;
            }
            case ';': {
                this.peak = this.read();
                if (Character.isWhitespace(this.peak)) {
                    return 8;
                }
                this.cb[i++] = 59;
                break;
            }
            case ':': {
                this.peak = this.read();
                if (Character.isWhitespace(this.peak)) {
                    return 9;
                }
                this.cb[i++] = 58;
                break;
            }
            case '-': {
                sign = -1;
                this.cb[i++] = this.peak;
                this.peak = this.read();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int value = 0;
                while (this.peak >= '0' && this.peak <= '9') {
                    value = 10 * value + (this.peak - 48);
                    this.cb[i++] = this.peak;
                    this.peak = this.read();
                }
                if (this.peak == '\u0000' || Character.isWhitespace(this.peak)) {
                    if ((value = sign * value) >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                        word = new String(this.cb, 0, i);
                        return 4;
                    }
                    word = new String(this.cb, 0, i);
                    return 5;
                }
                if (this.peak != '.') break;
                do {
                    this.cb[i++] = this.peak;
                    this.peak = this.read();
                } while (this.peak >= '0' && this.peak <= '9');
                if (this.peak != '\u0000' && !Character.isWhitespace(this.peak)) break;
                word = new String(this.cb, 0, i);
                return 7;
            }
        }
        while (this.peak != '\u0000' && !Character.isWhitespace(this.peak)) {
            this.cb[i++] = this.peak;
            this.peak = this.read();
        }
        word = new String(this.cb, 0, i);
        return 2;
    }

    protected ProtocolException getException(String errorMsg) {
        if (word.equals("error")) {
            try {
                return new ProtocolException(errorMsg + "\n" + locale.getString("m_error") + ": " + this.readBlock());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ProtocolException(errorMsg);
    }

    static {
        locale = ResourceBundle.getBundle("locale.LexicalAnalyser");
    }
}

