/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system.concrete;

import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.concrete.ConcreteState;
import java.math.BigDecimal;

public class ConcreteTransitionRecord {
    protected SystemEdgeSelect[] edges;
    protected ConcreteState target;
    private BigDecimal delay;

    public ConcreteTransitionRecord(BigDecimal delay, SystemEdgeSelect[] edges, ConcreteState target) {
        this.edges = edges;
        this.target = target;
        this.delay = delay;
    }

    public String getEdgeDescription() {
        if (this.edges.length > 1) {
            StringBuilder s = new StringBuilder();
            String channel = this.edges[0].getName();
            if (channel.length() > 0) {
                s.append(channel.substring(0, channel.length() - 1));
            }
            s.append(": ");
            s.append(this.edges[0].getProcessName());
            if (this.edges.length == 1 || this.edges.length > 2) {
                s.append(" \u21d2 ");
            } else {
                s.append(" \u2192 ");
            }
            s.append(this.edges[1].getProcessName());
            for (int i = 2; i < this.edges.length; ++i) {
                s.append(", ");
                s.append(this.edges[i].getProcessName());
            }
            return s.toString();
        }
        if (this.edges.length > 0) {
            return this.edges[0].getProcessName();
        }
        return "deadlock";
    }

    public ConcreteState getTarget() {
        return this.target;
    }

    public void setTarget(ConcreteState t) {
        this.target = t;
    }

    public SystemEdgeSelect[] getEdges() {
        return this.edges;
    }

    public void setEdges(SystemEdgeSelect[] e) {
        this.edges = e;
    }

    public BigDecimal getDelay() {
        return this.delay;
    }

    public void setDelay(BigDecimal d) {
        this.delay = d;
    }
}

