/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system.concrete;

import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.concrete.Limit;
import java.util.ResourceBundle;

public class ConcreteTransition {
    private static ResourceBundle locale = ResourceBundle.getBundle("locale.Simulator");
    private SystemEdgeSelect[] edges_ws;
    private int player;
    private int status;
    private Limit startEnabled;
    private Limit endEnabled;
    private Limit startSelect;
    private Limit endSelect;

    public ConcreteTransition(SystemEdgeSelect[] edges, int player, int status, Limit startEnabled, Limit endEnabled, Limit startSelect, Limit endSelect) {
        this.edges_ws = edges;
        this.player = player;
        this.status = status;
        this.startEnabled = startEnabled;
        this.endEnabled = endEnabled;
        this.startSelect = startSelect;
        this.endSelect = endSelect;
    }

    public boolean isSelectable() {
        return this.endSelect.isUnbounded() || this.startSelect.getValue().compareTo(this.endSelect.getValue()) <= 0;
    }

    public String getLabel() {
        switch (this.edges_ws.length) {
            case 0: {
                if (this.status == 1) {
                    return locale.getString("s_losing");
                }
                if (this.status == 2) {
                    return locale.getString("s_winning");
                }
                throw new RuntimeException("Strange transition without edges");
            }
            case 1: {
                StringBuilder s1 = new StringBuilder();
                s1.append(this.edges_ws[0].getSelectList());
                s1.append(this.edges_ws[0].getProcessName());
                return s1.toString();
            }
        }
        StringBuilder s = new StringBuilder();
        String channel = this.edges_ws[0].getName();
        if (channel.length() > 0) {
            s.append(channel.substring(0, channel.length() - 1));
        }
        s.append(": ");
        s.append(this.edges_ws[0].getSelectList());
        s.append(this.edges_ws[0].getProcessName());
        if (this.edges_ws.length == 1 || this.edges_ws.length > 2) {
            s.append(" \u21d2 ");
        } else {
            s.append(" \u2192 ");
        }
        s.append(this.edges_ws[1].getSelectList());
        s.append(this.edges_ws[1].getProcessName());
        for (int i = 2; i < this.edges_ws.length; ++i) {
            s.append(", ");
            s.append(this.edges_ws[i].getSelectList());
            s.append(this.edges_ws[i].getProcessName());
        }
        return s.toString();
    }

    public SystemEdgeSelect[] getEdges() {
        return this.edges_ws;
    }

    public int getPlayer() {
        return this.player;
    }

    public int getStatus() {
        return this.status;
    }

    public Limit getStartEnabled() {
        return this.startEnabled;
    }

    public Limit getEndEnabled() {
        return this.endEnabled;
    }

    public Limit getStartSelect() {
        return this.startSelect;
    }

    public Limit getEndSelect() {
        return this.endSelect;
    }
}

