/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemState;

public abstract class AbstractTransition {
    protected SystemEdge[] edges;
    protected SystemState target;

    public String getEdgeDescription() {
        if (this.edges.length > 1) {
            StringBuilder s = new StringBuilder();
            String channel = this.edges[0].getName();
            if (channel.length() > 0) {
                s.append(channel.substring(0, channel.length() - 1));
            }
            s.append(": ");
            s.append(this.edges[0].getProcessName());
            if (this.edges.length == 1 || this.edges.length > 2) {
                s.append(" \u21d2 ");
            } else {
                s.append(" \u2192 ");
            }
            s.append(this.edges[1].getProcessName());
            for (int i = 2; i < this.edges.length; ++i) {
                s.append(", ");
                s.append(this.edges[i].getProcessName());
            }
            return s.toString();
        }
        if (this.edges.length > 0) {
            return this.edges[0].getProcessName();
        }
        return "deadlock";
    }

    public SystemState getTarget() {
        return this.target;
    }

    public void setTarget(SystemState t) {
        this.target = t;
    }

    public SystemEdge[] getEdges() {
        return this.edges;
    }

    public void setEdges(SystemEdge[] e) {
        this.edges = e;
    }
}

