/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractLocation;
import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscElement;
import com.uppaal.model.core2.lsc.LscTemplate;
import com.uppaal.model.core2.lsc.Message;
import com.uppaal.model.core2.lsc.Prechart;
import com.uppaal.model.core2.lsc.Update;
import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class XMLReader {
    protected XMLEventReader reader;
    protected XMLEvent event;
    protected Map<String, AbstractLocation> locations = new HashMap<String, AbstractLocation>();
    protected Map<String, InstanceLine> instances = new HashMap<String, InstanceLine>();
    private ArrayList<Integer> yloccoords = new ArrayList();
    private Map<Integer, Condition> yConditions = new HashMap<Integer, Condition>();
    private static XMLResolver resolver;
    private String inst = null;

    public XMLReader(InputStream s) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        if (resolver != null) {
            inputFactory.setXMLResolver(resolver);
        }
        this.reader = inputFactory.createXMLEventReader(s);
    }

    public static void setXMLResolver(XMLResolver value) {
        resolver = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(Element prototype) throws XMLStreamException {
        Document document = null;
        try {
            if (this.reader.hasNext()) {
                this.next();
                document = new Document(prototype);
                this.project(document);
            }
        }
        finally {
            this.event = null;
        }
        return document;
    }

    protected void next() throws XMLStreamException {
        this.event = this.reader.nextEvent();
    }

    protected boolean begin(String tag) throws XMLStreamException {
        while (!this.event.isStartElement() && !this.event.isEndDocument()) {
            this.next();
        }
        return !this.event.isEndDocument() && this.event.asStartElement().getName().getLocalPart().equals(tag);
    }

    protected String readText() throws XMLStreamException {
        String s = "";
        while (this.event.isCharacters()) {
            s = s + this.event.asCharacters().getData();
            this.next();
        }
        return s;
    }

    protected String getAttribute(String name) {
        Attribute attribute = this.event.asStartElement().getAttributeByName(new QName(name));
        return attribute == null ? null : attribute.getValue();
    }

    protected Integer getCoordinate(String attribute) {
        try {
            String s = this.getAttribute(attribute);
            return s == null ? null : Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid " + attribute + ": not an integer");
            return null;
        }
    }

    protected Color getColor(String attribute) {
        try {
            String s = this.getAttribute(attribute);
            return s == null ? null : Color.decode(s);
        }
        catch (NumberFormatException e) {
            System.err.println("Not a color: " + attribute);
            return null;
        }
    }

    protected void project(Document document) throws XMLStreamException {
        if (!this.begin("project")) {
            this.begin("nta");
        }
        this.next();
        this.declaration(document);
        while (this.begin("template") || this.begin("lsc")) {
            this.templates(document);
            this.lscTemplates(document);
        }
        this.instantiation(document);
        this.system(document);
    }

    protected void declaration(Node node) throws XMLStreamException {
        if (this.begin("declaration")) {
            this.next();
            node.setProperty("declaration", this.readText());
        }
    }

    protected void name(Node node) throws XMLStreamException {
        if (this.begin("name")) {
            Integer x = this.getCoordinate("x");
            Integer y = this.getCoordinate("y");
            Color color = this.getColor("color");
            this.next();
            Property property = node.setProperty("name", this.readText());
            property.setProperty("x", x);
            property.setProperty("color", color);
            property.setProperty("y", y);
        }
    }

    protected void fixedname(Node node) throws XMLStreamException {
        if (this.begin("name")) {
            this.next();
            node.setProperty("name", this.readText());
        }
    }

    protected void parameter(AbstractTemplate node) throws XMLStreamException {
        if (this.begin("parameter")) {
            this.next();
            node.setProperty("parameter", this.readText());
        }
    }

    protected void type(AbstractTemplate node) throws XMLStreamException {
        if (this.begin("type")) {
            this.next();
            node.setProperty("type", this.readText());
        }
    }

    protected void mode(AbstractTemplate node) throws XMLStreamException {
        if (this.begin("mode")) {
            this.next();
            node.setProperty("mode", this.readText());
        }
    }

    protected void role(AbstractTemplate node) throws XMLStreamException {
        if (this.begin("role")) {
            this.next();
            node.setProperty("role", this.readText());
        }
    }

    protected void labels(Node node) throws XMLStreamException {
        while (this.begin("label")) {
            String kind = this.getAttribute("kind");
            Integer x = this.getCoordinate("x");
            Integer y = this.getCoordinate("y");
            Color color = this.getColor("color");
            this.next();
            if (kind == null) continue;
            Property property = node.setProperty(kind, this.readText());
            property.setProperty("x", x);
            property.setProperty("y", y);
            property.setProperty("color", color);
        }
    }

    protected void label(LscElement element) throws XMLStreamException {
        if (this.begin("label")) {
            Integer x = this.getCoordinate("x");
            Integer y = this.getCoordinate("y");
            Color color = this.getColor("color");
            String kind = this.getAttribute("kind");
            this.next();
            if (kind != null) {
                Property property = element.setProperty(kind, this.readText());
                if (element instanceof Message) {
                    property.setProperty("x", x);
                    if (x != null) {
                        property.setProperty("x", x);
                        int sx = ((Message)element).getSource().getX();
                        int tx = ((Message)element).getTarget().getX();
                        Float f = Float.valueOf(((float)x.intValue() - (float)sx) / (float)(tx - sx));
                        property.setProperty("f", f);
                    }
                    property.setProperty("y", y);
                    property.setProperty("color", color);
                }
            }
        }
    }

    protected void temperature(Node node) throws XMLStreamException {
        this.begin("temperature");
        this.next();
        node.setProperty("hot", this.readText().equals("hot"));
    }

    protected void committed(Location location) throws XMLStreamException {
        if (this.begin("committed")) {
            this.next();
            location.setProperty("committed", true);
        }
    }

    protected void urgent(Location location) throws XMLStreamException {
        if (this.begin("urgent")) {
            this.next();
            location.setProperty("urgent", true);
        }
    }

    protected void init(Template template) throws XMLStreamException {
        if (this.begin("init")) {
            AbstractLocation location = this.locations.get(this.getAttribute("ref"));
            if (location != null) {
                location.setProperty("init", true);
            }
            this.next();
        }
    }

    protected void locations(Template template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("location")) {
            Location location = template.createLocation();
            location.setProperty("x", this.getCoordinate("x"));
            location.setProperty("y", this.getCoordinate("y"));
            location.setProperty("color", this.getColor("color"));
            this.locations.put(this.getAttribute("id"), location);
            last = template.insert(location, last);
            this.next();
            this.name(location);
            this.labels(location);
            this.urgent(location);
            this.committed(location);
        }
    }

    protected void branchpoints(Template template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("branchpoint")) {
            BranchPoint branchPoint = template.createBranchPoint();
            branchPoint.setProperty("x", this.getCoordinate("x"));
            branchPoint.setProperty("y", this.getCoordinate("y"));
            branchPoint.setProperty("color", this.getColor("color"));
            this.locations.put(this.getAttribute("id"), branchPoint);
            last = template.insert(branchPoint, last);
            this.next();
        }
    }

    protected AbstractLocation source() throws XMLStreamException {
        if (this.begin("source")) {
            AbstractLocation location = this.locations.get(this.getAttribute("ref"));
            this.next();
            return location;
        }
        return null;
    }

    protected AbstractLocation target() throws XMLStreamException {
        if (this.begin("target")) {
            AbstractLocation location = this.locations.get(this.getAttribute("ref"));
            this.next();
            return location;
        }
        return null;
    }

    protected void nails(Edge edge) throws XMLStreamException {
        Node last = edge.getLast();
        while (this.begin("nail")) {
            Integer x = this.getCoordinate("x");
            Integer y = this.getCoordinate("y");
            Nail nail = edge.createNail();
            nail.setProperty("x", x);
            nail.setProperty("y", y);
            last = edge.insert(nail, last);
            this.next();
        }
    }

    protected void edges(Template template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("transition")) {
            String controllable = this.getAttribute("controllable");
            Color color = this.getColor("color");
            this.next();
            AbstractLocation s = this.source();
            AbstractLocation t = this.target();
            if (s != null && t != null) {
                Edge edge = template.createEdge();
                last = template.insert(edge, last);
                if (controllable != null && controllable.equals("false")) {
                    edge.setProperty("controllable", false);
                }
                edge.setSource(s);
                edge.setTarget(t);
                edge.setProperty("color", color);
                this.labels(edge);
                this.nails(edge);
                continue;
            }
            System.err.println("Skipping edge due to invalid source or target");
            while (this.begin("label")) {
                this.next();
            }
            while (this.begin("nail")) {
                this.next();
            }
        }
    }

    protected void templates(Document document) throws XMLStreamException {
        Node last = document.getLastTATemplate();
        while (this.begin("template")) {
            this.next();
            Template template = document.createTemplate();
            last = document.insert(template, last);
            this.name(template);
            this.parameter(template);
            this.declaration(template);
            this.locations(template);
            this.branchpoints(template);
            this.init(template);
            this.edges(template);
        }
    }

    protected void lscTemplates(Document document) throws XMLStreamException {
        Node last = document.getLast();
        while (this.begin("lsc")) {
            this.instances.clear();
            this.yloccoords.clear();
            this.yConditions.clear();
            this.next();
            LscTemplate template = document.createLscTemplate();
            last = document.insert(template, last);
            this.name(template);
            this.parameter(template);
            this.type(template);
            this.mode(template);
            this.role(template);
            this.declaration(template);
            this.yloccoord(template);
            this.instances(template);
            this.prechart(template);
            this.messages(template);
            this.conditions(template);
            this.updates(template);
        }
    }

    protected void prechart(LscTemplate template) throws XMLStreamException {
        Node last = template.getLast();
        if (this.begin("prechart")) {
            Integer x = this.getCoordinate("x");
            Color color = this.getColor("color");
            this.next();
            Prechart prechart = template.createPrechart();
            prechart.setProperty("x", x);
            if (color != null) {
                prechart.setProperty("color", color);
            }
            this.yLocation(prechart, "y");
            for (InstanceLine instance : this.instances.values()) {
                prechart.add(instance);
            }
            last = template.insert(prechart, last);
        }
    }

    protected void yLocation(LscElement element, String property) throws XMLStreamException {
        Integer number = this.getYLocation();
        if (number != null) {
            element.setProperty(property, this.yloccoords.get(number));
        }
    }

    protected Integer getYLocation() throws XMLStreamException {
        if (this.begin("lsclocation")) {
            this.next();
            return Integer.valueOf(this.readText());
        }
        return null;
    }

    protected void yloccoord(LscTemplate template) throws XMLStreamException {
        Integer y = 0;
        while (this.begin("yloccoord")) {
            y = this.getCoordinate("y");
            this.yloccoords.add(y);
            this.next();
        }
        Collections.sort(this.yloccoords);
        int max = this.yloccoords.get(this.yloccoords.size() - 1);
        template.setProperty("length", max - 10);
    }

    protected void instances(LscTemplate template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("instance")) {
            InstanceLine instance = template.createInstanceLine();
            instance.setProperty("x", this.getCoordinate("x"));
            instance.setProperty("y", 0);
            instance.setProperty("color", this.getColor("color"));
            String id = this.getAttribute("id");
            this.instances.put(id, instance);
            last = template.insert(instance, last);
            this.next();
            this.fixedname(instance);
        }
    }

    protected void messages(LscTemplate template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("message")) {
            Color color = this.getColor("color");
            Integer x = this.getCoordinate("x");
            this.next();
            InstanceLine s = this.messageSource();
            InstanceLine t = this.messageTarget();
            if (s != null && t != null) {
                Message message = template.createMessage();
                if (color != null) {
                    message.setProperty("color", color);
                }
                if (x != null) {
                    message.setProperty("x", x);
                }
                last = template.insert(message, last);
                message.setSource(s);
                message.setTarget(t);
                this.yLocation(message, "y");
                this.label(message);
                continue;
            }
            System.err.println("Skipping message due to invalid source or target");
            while (this.begin("location")) {
                this.next();
            }
            while (this.begin("label")) {
                this.next();
            }
        }
    }

    protected void conditions(LscTemplate template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("condition")) {
            Color color = this.getColor("color");
            Integer x = this.getCoordinate("x");
            this.next();
            Condition condition = template.createCondition();
            ArrayList<InstanceLine> anchors = this.anchors(condition);
            if (!anchors.isEmpty()) {
                Integer number;
                if (x != null) {
                    condition.setProperty("x", x);
                }
                if ((number = this.getYLocation()) != null) {
                    Integer y = this.yloccoords.get(number);
                    condition.setProperty("y", y);
                    this.yConditions.put(y, condition);
                }
                if (color != null) {
                    condition.setProperty("color", color);
                }
                condition.setAnchors(anchors);
                this.temperature(condition);
                this.label(condition);
                last = template.insert(condition, last);
                continue;
            }
            System.err.println("Skipping condition due to invalid anchor");
            condition = null;
            while (this.begin("temperature")) {
                this.next();
            }
            while (this.begin("label")) {
                this.next();
            }
        }
    }

    protected void updates(LscTemplate template) throws XMLStreamException {
        Node last = template.getLast();
        while (this.begin("update")) {
            Color color = this.getColor("color");
            Integer x = this.getCoordinate("x");
            Integer y = 0;
            this.next();
            Update update = template.createUpdate();
            InstanceLine anchor = this.anchor(update);
            if (anchor != null) {
                update.setProperty("x", x);
                Integer number = this.getYLocation();
                if (number != null) {
                    y = this.yloccoords.get(number);
                }
                if (this.yConditions.keySet().contains(y)) {
                    update.setAnchoredToCondition(this.yConditions.get(y));
                } else {
                    update.setProperty("y", y);
                }
                update.setProperty("color", color);
                update.setAnchor(anchor);
                this.label(update);
                last = template.insert(update, last);
                continue;
            }
            update = null;
            System.err.println("Skipping update due to invalid anchor");
            while (this.begin("label")) {
                this.next();
            }
        }
    }

    protected ArrayList<InstanceLine> anchors(Condition element) throws XMLStreamException {
        ArrayList<InstanceLine> anchors = new ArrayList<InstanceLine>();
        while (this.begin("anchor")) {
            InstanceLine instance = this.instances.get(this.getAttribute("instanceid"));
            this.next();
            anchors.add(instance);
        }
        return anchors;
    }

    protected InstanceLine anchor(Update element) throws XMLStreamException {
        this.begin("anchor");
        InstanceLine instance = this.instances.get(this.getAttribute("instanceid"));
        this.next();
        return instance;
    }

    protected InstanceLine messageSource() throws XMLStreamException {
        if (this.begin("source")) {
            InstanceLine instance = this.instances.get(this.getAttribute("ref"));
            this.next();
            return instance;
        }
        return null;
    }

    protected InstanceLine messageTarget() throws XMLStreamException {
        if (this.begin("target")) {
            InstanceLine instance = this.instances.get(this.getAttribute("ref"));
            this.next();
            return instance;
        }
        return null;
    }

    protected void instantiation(Document document) throws XMLStreamException {
        if (this.begin("instantiation")) {
            this.next();
            this.inst = this.readText();
        }
    }

    protected void system(Document document) throws XMLStreamException {
        if (this.begin("system")) {
            this.next();
            if (this.inst == null) {
                document.setProperty("system", this.readText());
            } else {
                document.setProperty("system", this.inst + "\n" + this.readText());
                this.inst = null;
            }
        }
    }
}

