/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2.lsc;

import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class LscElement
extends Node
implements LscConstants {
    public LscElement(Element prototype) {
        super(prototype);
    }

    public String getTemperature() {
        return (Boolean)this.getPropertyValue("hot") != false ? "hot" : "cold";
    }

    public boolean isHot() {
        return (Boolean)this.getPropertyValue("hot");
    }

    public static int getWidth(String string, Font font, Graphics2D g) {
        if (g == null) {
            BufferedImage bufferedImage = new BufferedImage(2, 2, 7);
            g = bufferedImage.createGraphics();
        }
        g.setFont(font);
        return g.getFontMetrics().stringWidth(string);
    }

    public static Color lighter(Color color, float white) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return new Color((int)((float)r * (1.0f - white) + 255.0f * white), (int)((float)g * (1.0f - white) + 255.0f * white), (int)((float)b * (1.0f - white) + 255.0f * white));
    }

    public int getWidth(Graphics2D g) {
        String s = this.getLabelValue();
        Font font = (Font)this.getPropertyValue("font");
        return LscElement.getWidth(s, font, g);
    }

    public String getLabelValue() {
        return "";
    }

    public Color getColor(Element element) {
        if (this.getPropertyValue("color") != null) {
            return (Color)this.getPropertyValue("color");
        }
        if (((LscElement)element).isHot()) {
            return CONDITION_HOT_COL;
        }
        return CONDITION_COLD_COL;
    }

    public ArrayList<InstanceLine> getAnchors() {
        return null;
    }

    public Element getLabel() {
        Property label = this.getProperty("condition");
        return label != null ? label : this.getProperty("update");
    }
}

