/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.Problem;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.ServerException;
import com.uppaal.model.core2.Document;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.GanttBar;
import com.uppaal.model.system.GanttChart;
import com.uppaal.model.system.GanttRow;
import com.uppaal.model.system.IdentifierTranslator;
import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteSuccessor;
import com.uppaal.model.system.concrete.ConcreteTransition;
import com.uppaal.model.system.concrete.ConcreteVariable;
import com.uppaal.model.system.concrete.Limit;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;

public class Parser
extends LexicalAnalyser {
    private static ResourceBundle locale = ResourceBundle.getBundle("locale.Parser");

    public Parser(InputStream in) {
        super(in);
    }

    public void parseProlog() throws EngineException, IOException {
        String response = this.parseId();
        if (response.equals("error")) {
            throw new ServerException(this.readBlock());
        }
        if (!response.equals("ok")) {
            throw new ProtocolException("Bug: Ok expected");
        }
    }

    public String parseId() throws ProtocolException, IOException {
        if (this.nextToken() != 2) {
            throw new ProtocolException("Bug: Word expected");
        }
        return this.getWord();
    }

    public int parseInteger() throws ProtocolException, IOException, ServerException {
        int token = this.nextToken();
        if (token != 4) {
            if (token == 2 && this.getWord().equals("error")) {
                throw new ServerException(this.readBlock());
            }
            throw new ProtocolException("Bug: Integer expected");
        }
        return this.getIntValue();
    }

    public long parseLong() throws ProtocolException, IOException, ServerException {
        int token = this.nextToken();
        if (token != 4 && token != 5) {
            if (token == 2 && this.getWord().equals("error")) {
                throw new ServerException(this.readBlock());
            }
            throw new ProtocolException("Bug: Long integer expected");
        }
        return this.getValue();
    }

    public BigDecimal parseBigDecimal() throws ProtocolException, IOException {
        switch (this.nextToken()) {
            case 4: 
            case 5: 
            case 7: {
                return this.getFloat();
            }
            case 2: {
                if (!this.getWord().equals("inf")) break;
                return null;
            }
        }
        throw this.getException("Floating point value expected, not '" + this.getWord() + "'");
    }

    public Limit parseLimit() throws ProtocolException, IOException, ServerException {
        return new Limit(this.parseBigDecimal(), this.parseInteger() != 0);
    }

    public void parseEnd() throws ProtocolException, IOException {
        int token = this.nextToken();
        if (token != 1) {
            throw new ProtocolException("Bug: Dot expected");
        }
    }

    public void parsePartialEnd() throws ProtocolException, IOException {
        int token = this.nextToken();
        if (token != 8) {
            throw new ProtocolException("Bug: Semicolon expected");
        }
    }

    public void parsePartialBisEnd() throws ProtocolException, IOException {
        int token = this.nextToken();
        if (token != 9) {
            throw new ProtocolException("Bug: Colon expected");
        }
    }

    public SymbolicState parseSymbolicState(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        SystemLocation[] l = this.locationVector(system);
        Polyhedron z = this.zone(system);
        int[] v = this.variableVector(system);
        return new SymbolicState(l, v, z);
    }

    private SystemLocation[] locationVector(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        SystemLocation[] locations = new SystemLocation[system.getNoOfProcesses()];
        int i = 0;
        do {
            locations[i] = system.getLocation(i, this.parseInteger());
            ++i;
        } while (this.getLookahead() != 1);
        this.parseEnd();
        return locations;
    }

    private int[] variableVector(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        int[] vector = new int[system.getNoOfVariables()];
        int i = 0;
        while (this.getLookahead() != 1) {
            vector[i++] = this.parseInteger();
        }
        this.parseEnd();
        return vector;
    }

    private Polyhedron zone(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        Polyhedron pol = new Polyhedron(system);
        while (this.getLookahead() != 1) {
            int i = this.parseInteger();
            int j = this.parseInteger();
            int b = this.parseInteger();
            pol.add(i, j, b ^ 1);
            this.parseEnd();
        }
        this.parseEnd();
        pol.trim();
        return pol;
    }

    public SystemEdge[] parseEdges(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        this.parseInteger();
        LinkedList<SystemEdge> l = new LinkedList<SystemEdge>();
        while (this.getLookahead() != 1) {
            l.add(this.edge(system));
        }
        this.parseEnd();
        return l.toArray(new SystemEdge[0]);
    }

    private SystemEdge edge(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        int i = this.parseInteger();
        int j = this.parseInteger();
        return system.getEdge(i, j);
    }

    private SystemEdgeSelect edgeCon(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        int i = this.parseInteger();
        int j = this.parseInteger();
        LinkedList<Integer> l = new LinkedList<Integer>();
        while (this.getLookahead() != 8) {
            l.add(this.parseInteger());
        }
        this.parsePartialEnd();
        return system.createEdgeCon(i, j, l);
    }

    public ArrayList<SymbolicTransition> parseEnabledTransitions(UppaalSystem system) throws EngineException, IOException {
        ArrayList<SymbolicTransition> succs = new ArrayList<SymbolicTransition>();
        this.parseProlog();
        block6: while (this.getLookahead() != 1) {
            switch (this.parseInteger()) {
                case 0: {
                    SymbolicState src = this.parseSymbolicState(system);
                    SystemEdge[] e = this.parseEdges(system);
                    SymbolicState dst = this.parseSymbolicState(system);
                    succs.add(new SymbolicTransition(src, e, dst));
                    continue block6;
                }
                case 1: {
                    SymbolicState src = this.parseSymbolicState(system);
                    succs.add(new SymbolicTransition(src, new SystemEdge[0], null));
                    continue block6;
                }
                case 2: {
                    SymbolicState src = this.parseSymbolicState(system);
                    SystemEdge[] e = this.parseEdges(system);
                    succs.add(new SymbolicTransition(src, e, null));
                    continue block6;
                }
                case 3: {
                    this.parseEnd();
                    return null;
                }
            }
            throw new ProtocolException("Bug: Unknown transition type");
        }
        this.parseEnd();
        return succs;
    }

    public void parseAcknowledgement() throws EngineException, IOException {
        this.parseProlog();
        this.parseEnd();
    }

    public String parseBlock() throws EngineException, IOException {
        this.parseProlog();
        return this.readBlock();
    }

    public void parseGanttHeader(UppaalSystem system) throws ProtocolException, EngineException, IOException {
        int noOfRows = this.parseInteger();
        int noOfParsedRows = 0;
        GanttChart gc = system.getGanttChart();
        if (noOfRows > 0) {
            if (gc == null) {
                gc = new GanttChart();
            } else {
                gc.clearChart();
            }
            while (this.getLookahead() != 1) {
                String Label;
                try {
                    Label = this.parseId();
                }
                catch (ProtocolException e) {
                    throw new IllegalArgumentException("Expected an integer in GanttChart " + e);
                }
                GanttRow r = new GanttRow(Label);
                gc.addRow(r);
                ++noOfParsedRows;
            }
            if (noOfRows != noOfParsedRows) {
                throw new ProtocolException("Gantt Chart: Expected " + noOfRows + " Rows. Only got " + noOfParsedRows + ".");
            }
        }
        this.parseEnd();
        system.setGanttChart(gc);
    }

    public SymbolicState parseSymbolicInitial(UppaalSystem system) throws EngineException, IOException {
        this.parseProlog();
        SymbolicState state = this.parseSymbolicState(system);
        return state;
    }

    public ConcreteState parseConcreteInitial(UppaalSystem system) throws EngineException, IOException, ServerException {
        this.parseProlog();
        ConcreteState state = this.parseConcreteState(system);
        this.parseEnd();
        return state;
    }

    public UppaalSystem parseSystem(Document document) throws EngineException, IOException {
        ArrayList<String> vars = this.ids();
        ArrayList<String> clocks = this.ids();
        UppaalSystem system = new UppaalSystem(document);
        system.setVariables(vars);
        system.setClocks(clocks);
        this.processes(system);
        this.parseGanttHeader(system);
        return system;
    }

    public LscProcess parseLscProcess(Document document) throws EngineException, IOException {
        return null;
    }

    private ArrayList<String> ids() throws EngineException, IOException {
        ArrayList<String> ids = new ArrayList<String>();
        while (this.getLookahead() != 1) {
            ids.add(this.parseId());
        }
        this.parseEnd();
        return ids;
    }

    private void processes(UppaalSystem system) throws EngineException, IOException {
        while (this.getLookahead() != 1) {
            String processName = this.parseId();
            String templateName = this.parseId();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            while (this.getLookahead() != 1) {
                String parameter = this.parseId();
                String argument = this.readBlock();
                parameterMap.put(parameter, argument);
            }
            this.parseEnd();
            while (this.getLookahead() != 1) {
                this.parseInteger();
            }
            this.parseEnd();
            system.addProcess(processName, templateName, new IdentifierTranslator(parameterMap));
        }
        this.parseEnd();
    }

    private void lscProcess(UppaalSystem system) throws EngineException, IOException {
        if (this.getLookahead() != 1) {
            // empty if block
        }
        this.parseEnd();
    }

    public ArrayList<Problem> parseProblems() throws EngineException, IOException {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        this.parseProblems(problems);
        return problems;
    }

    public void parseProblems(ArrayList<Problem> problems) throws EngineException, IOException {
        this.parseProlog();
        while (this.getLookahead() != 1) {
            problems.add(this.problem());
        }
        this.parseEnd();
    }

    public boolean skipProblems() throws EngineException, IOException {
        this.parseProlog();
        if (this.getLookahead() == 1) {
            this.parseEnd();
            return false;
        }
        do {
            this.problem();
        } while (this.getLookahead() != 1);
        this.parseEnd();
        return true;
    }

    private Problem problem() throws EngineException, IOException {
        String type = this.parseId();
        String path = this.readBlock();
        int fline = this.parseInteger();
        int fcolumn = this.parseInteger();
        int lline = this.parseInteger();
        int lcolumn = this.parseInteger();
        String msg = this.readBlock();
        return new Problem(type, path, fline, fcolumn, lline, lcolumn, msg);
    }

    public char parseQueryResult() throws EngineException, IOException {
        this.parseProlog();
        return this.parseId().charAt(0);
    }

    public ArrayList<SymbolicTransition> parseXTRTrace(UppaalSystem system) throws ProtocolException, IOException {
        ArrayList<SymbolicTransition> trace = new ArrayList<SymbolicTransition>();
        try {
            SymbolicState src = this.parseSymbolicState(system);
            trace.add(new SymbolicTransition(null, null, src));
            while (this.getLookahead() != 1) {
                SymbolicState dst = this.parseSymbolicState(system);
                SystemEdge[] edges = this.edgesXTR(system);
                trace.add(new SymbolicTransition(src, edges, dst));
                src = dst;
            }
            this.parseEnd();
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(locale.getString("trace_mismatch"));
        }
        return trace;
    }

    private SystemEdge[] edgesXTR(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        ArrayList<SystemEdge> edges = new ArrayList<SystemEdge>();
        do {
            edges.add(this.edge(system));
        } while (this.getLookahead() != 1);
        this.parseEnd();
        SystemEdge[] se = new SystemEdge[edges.size()];
        return edges.toArray(se);
    }

    public ConcreteState parseConcreteState(UppaalSystem system) throws IOException, ProtocolException, ServerException {
        int cnt = this.parseInteger();
        SystemLocation[] locations = new SystemLocation[cnt];
        for (int i = 0; i < cnt; ++i) {
            locations[i] = system.getLocation(i, this.parseInteger());
        }
        cnt = this.parseInteger();
        ConcreteVariable[] variables = new ConcreteVariable[cnt];
        for (int i = 0; i < cnt; ++i) {
            variables[i] = new ConcreteVariable(this.parseBigDecimal(), this.parseInteger());
        }
        Limit invariant = this.parseLimit();
        return new ConcreteState(invariant, locations, variables);
    }

    public ConcreteTransition parseConcreteTransition(UppaalSystem system) throws IOException, ProtocolException, ServerException {
        int player = this.parseInteger();
        Limit startEnabled = this.parseLimit();
        Limit endEnabled = this.parseLimit();
        Limit startSelect = this.parseLimit();
        Limit endSelect = this.parseLimit();
        int status = this.parseInteger();
        int length = this.parseInteger();
        LinkedList<SystemEdgeSelect> listEdge = new LinkedList<SystemEdgeSelect>();
        while (this.getLookahead() != 9) {
            int i = this.parseInteger();
            int j = this.parseInteger();
            LinkedList<Integer> l = new LinkedList<Integer>();
            while (this.getLookahead() != 8) {
                l.add(this.parseInteger());
            }
            this.parsePartialEnd();
            listEdge.add(system.createEdgeCon(i, j, l));
        }
        this.parsePartialBisEnd();
        return new ConcreteTransition(listEdge.toArray(new SystemEdgeSelect[0]), player, status, startEnabled, endEnabled, startSelect, endSelect);
    }

    public ConcreteSuccessor parseConcreteSuccessor(UppaalSystem system) throws IOException, EngineException, ServerException {
        this.parseProlog();
        ConcreteState state = this.parseConcreteState(system);
        this.parseProlog();
        ArrayList<ConcreteTransition> transitions = new ArrayList<ConcreteTransition>();
        while (this.getLookahead() != 1) {
            transitions.add(this.parseConcreteTransition(system));
        }
        this.parseEnd();
        return new ConcreteSuccessor(state, transitions.toArray(new ConcreteTransition[0]));
    }

    public GanttChart parseGanttChart(UppaalSystem system, BigDecimal globalTime) throws ProtocolException, ServerException, IOException {
        int noOfBars = this.parseInteger();
        int id = 0;
        int Value = 0;
        GanttChart gc = system.getGanttChart();
        if (noOfBars > 0) {
            for (int noOfParsedBars = 0; this.getLookahead() != 1 && noOfParsedBars < noOfBars; ++noOfParsedBars) {
                id = this.parseInteger();
                Value = this.parseInteger();
                Limit From = this.parseLimit();
                Limit To = this.parseLimit();
                gc.getRow(id).addBar(new GanttBar(From, To, globalTime, Value));
            }
        }
        this.parseEnd();
        return gc;
    }
}

