/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemState;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class Transition {
    private SystemEdge[] edges;
    private SystemState source;
    private SystemState target;
    private String edgeDescription;

    public Transition(SystemState source, SystemEdge[] edges, SystemState target) {
        this(source, edges, target, null);
    }

    public Transition(SystemState source, SystemEdge[] edges, SystemState target, String edgeDescription) {
        this.source = source;
        this.edges = edges;
        this.target = target;
        this.edgeDescription = edgeDescription != null ? edgeDescription : Transition.makeEdgeDescription(edges);
    }

    public String traceFormat() {
        StringBuffer s = new StringBuffer("(");
        boolean start = true;
        for (SystemEdge edge : this.edges) {
            if (start) {
                start = false;
            } else {
                s.append(", ");
            }
            s.append(edge.getFormatedName());
        }
        s.append(')');
        return s.toString();
    }

    public String toServerFormat() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.edges.length);
        for (SystemEdge edge : this.edges) {
            buf.append('\n');
            buf.append(edge.getProcess().getIndex()).append('\n');
            buf.append(edge.getIndex() + 1);
        }
        return buf.toString();
    }

    public void writeXTRFormat(Writer writer) throws IOException {
        this.getTarget().writeXTRFormat(writer);
        for (SystemEdge edge : this.edges) {
            edge.writeXTRFormat(writer);
        }
        writer.write(".\n");
    }

    public SystemState getSource() {
        return this.source;
    }

    public SystemState getTarget() {
        return this.target;
    }

    public SystemEdge[] getEdges() {
        return this.edges;
    }

    public SystemEdge getEdge(int i) {
        return this.edges[i];
    }

    public int getSize() {
        return this.edges.length;
    }

    public boolean involvesProcess(int process) {
        for (SystemEdge edge : this.edges) {
            if (edge.getProcess().getIndex() != process) continue;
            return true;
        }
        return false;
    }

    public String getEdgeDescription() {
        return this.edgeDescription;
    }

    private static String makeEdgeDescription(SystemEdge[] edges) {
        if (edges == null) {
            return null;
        }
        if (edges.length == 0) {
            return "deadlock";
        }
        String channel = edges[0].getName();
        if (channel != null && channel.length() > 0) {
            String channelName = channel.substring(0, channel.length() - 1);
            LinkedHashSet<String> processNames = new LinkedHashSet<String>();
            for (SystemEdge e : edges) {
                processNames.add(e.getProcessName());
            }
            Iterator namesIter = processNames.iterator();
            StringBuilder s = new StringBuilder();
            s.append(channelName);
            s.append(": ");
            s.append((String)namesIter.next());
            if (edges.length == 1 || edges.length > 2) {
                s.append(" \u21d2 ");
            } else {
                s.append(" \u2192 ");
            }
            while (namesIter.hasNext()) {
                s.append((String)namesIter.next());
                if (!namesIter.hasNext()) continue;
                s.append(", ");
            }
            return s.toString();
        }
        return edges[0].getProcessName();
    }
}

