/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTransaction;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Node;

public class InsertElementCommand
extends AbstractTransaction {
    protected Node parent;
    protected Node element;
    protected Node position;
    Node sibling;

    public InsertElementCommand(Node parent, Node position, Node element) {
        super(parent.getDocument());
        assert (parent == position.getParent());
        this.parent = parent;
        this.position = position;
        this.element = element;
        parent.insert(element, position);
        this.sibling = element.next != null ? element.next : element.previous;
    }

    @Override
    public void move(int x, int y) {
        assert (!this.committed) : "Cannot move committed element";
        assert (this.element != null) : "Cannot move canceled element";
        this.element.setProperty("x", x);
        this.element.setProperty("y", y);
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    protected void doCancel() {
        this.element.remove();
        this.element = null;
    }

    @Override
    protected void doExecute() {
        this.parent.insert(this.element, this.position);
    }

    @Override
    protected void doUndo() {
        this.element.remove();
    }

    @Override
    public Element getModifiedElement() {
        if (this.element.getParent() == null) {
            if (this.sibling != null) {
                return this.sibling;
            }
            return this.parent;
        }
        return this.element;
    }
}

