/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class SoundStreamHead
extends DefinitionTag {
    protected int playbackSoundRate;
    protected boolean playbackSoundSize16;
    protected boolean playbackSoundStereo;
    protected int streamSoundCompression;
    protected int streamSoundRate;
    protected boolean streamSoundSize16;
    protected boolean streamSoundStereo;
    protected int samples;
    protected int latencySeek;

    public SoundStreamHead(int playbackSoundRate, boolean playbackSoundStereo, int streamSoundRate, boolean streamSoundStereo, int samples) {
        this();
        this.playbackSoundRate = playbackSoundRate;
        this.playbackSoundSize16 = true;
        this.playbackSoundStereo = playbackSoundStereo;
        this.streamSoundCompression = 1;
        this.streamSoundRate = streamSoundRate;
        this.streamSoundSize16 = true;
        this.streamSoundStereo = streamSoundStereo;
        this.samples = samples;
    }

    public SoundStreamHead() {
        super(18, 1);
    }

    protected SoundStreamHead(int tagID, int version) {
        super(tagID, version);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        SoundStreamHead tag = new SoundStreamHead();
        tag.read(swf, len);
        return tag;
    }

    protected void read(SWFInputStream swf, int len) throws IOException {
        int reserved = (int)swf.readUBits(4);
        this.playbackSoundRate = (int)swf.readUBits(2);
        this.playbackSoundSize16 = swf.readBitFlag();
        this.playbackSoundStereo = swf.readBitFlag();
        this.streamSoundCompression = (int)swf.readUBits(4);
        this.streamSoundRate = (int)swf.readUBits(2);
        this.streamSoundSize16 = swf.readBitFlag();
        this.streamSoundStereo = swf.readBitFlag();
        this.samples = swf.readUnsignedShort();
        if (this.streamSoundCompression == 2) {
            this.latencySeek = swf.readShort();
        }
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        this.write(swf);
    }

    protected void write(SWFOutputStream swf) throws IOException {
        swf.writeUBits(0L, 4);
        swf.writeUBits(this.playbackSoundRate, 2);
        swf.writeBitFlag(this.playbackSoundSize16);
        swf.writeBitFlag(this.playbackSoundStereo);
        swf.writeUBits(this.streamSoundCompression, 4);
        swf.writeUBits(this.streamSoundRate, 2);
        swf.writeBitFlag(this.streamSoundSize16);
        swf.writeBitFlag(this.streamSoundStereo);
        swf.writeUnsignedShort(this.samples);
        if (this.streamSoundCompression == 2) {
            swf.writeShort(this.latencySeek);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString());
        return s.toString();
    }
}

