/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.Constraint;
import com.uppaal.model.system.UppaalSystem;
import java.util.ArrayList;
import java.util.List;

public class Polyhedron {
    private UppaalSystem system;
    private ArrayList<Constraint> constraintList;
    private static final String PROTOCOL_ERROR = "While reading polyhedron";

    static boolean isStrict(int bound) {
        return (bound & 1) == 0;
    }

    static int getValue(int bound) {
        return bound >> 1;
    }

    static int makeBound(int val, boolean strict) {
        return strict ? val << 1 : (val << 1) + 1;
    }

    static int setStrict(int val) {
        return val & 0xFFFFFFFE;
    }

    private String getClockName(int i) {
        return this.system.getClockName(i);
    }

    public Polyhedron(UppaalSystem system) {
        this.system = system;
        this.constraintList = new ArrayList();
    }

    private void computeCanonicalDBM(int[][] dbm) {
        int i;
        int j;
        int size = this.system.getNoOfClocks();
        for (j = 0; j < size; ++j) {
            dbm[0][j] = 1;
        }
        for (i = 1; i < size; ++i) {
            for (j = 0; j < size; ++j) {
                dbm[i][j] = Constraint.MAXBOUND;
            }
        }
        for (Constraint constr : this.constraintList) {
            assert (constr.isValid()) : "Polyhedron::computeCanonicalDBM(): illegal value for bound";
            dbm[constr.i][constr.j] = constr.bound;
        }
        for (int k = 0; k < size; ++k) {
            for (j = 0; j < size; ++j) {
                if (dbm[k][j] >= Constraint.MAXBOUND) continue;
                for (i = 0; i < size; ++i) {
                    int sum;
                    if (dbm[i][k] >= Constraint.MAXBOUND || (sum = (dbm[i][k] & 0xFFFFFFFE) + (dbm[k][j] & 0xFFFFFFFE) | dbm[i][k] & dbm[k][j] & 1) >= dbm[i][j]) continue;
                    dbm[i][j] = sum;
                }
            }
        }
    }

    public String writeTextualFormat() {
        StringBuilder s = new StringBuilder();
        for (Constraint c : this.constraintList) {
            s.append(String.valueOf(c.i));
            s.append("\n");
            s.append(String.valueOf(c.j));
            s.append("\n");
            s.append(String.valueOf(c.bound ^ 1));
            s.append("\n");
            s.append(".\n");
        }
        s.append(".\n");
        return new String(s);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Constraint c : this.constraintList) {
            s.append(c.i).append(' ').append(c.j).append(' ').append(c.bound ^ 1).append(' ');
        }
        return s.toString().trim();
    }

    private String lt(int bound) {
        return Polyhedron.isStrict(bound) ? " < " : " \u2264 ";
    }

    private String gt(int bound) {
        return Polyhedron.isStrict(bound) ? " > " : " \u2265 ";
    }

    private void appendInterval(int lower, int upper, StringBuilder s) {
        if (Polyhedron.getValue(lower) == -Polyhedron.getValue(upper)) {
            s.append(" = ");
            s.append(String.valueOf(Polyhedron.getValue(upper)));
        } else if (lower == Constraint.MAXBOUND) {
            s.append(this.lt(upper)).append(String.valueOf(Polyhedron.getValue(upper)));
        } else if (upper == Constraint.MAXBOUND) {
            s.append(this.gt(lower)).append(String.valueOf(-Polyhedron.getValue(lower)));
        } else {
            s.append(" \u2208 ");
            if (Polyhedron.isStrict(lower)) {
                s.append("(");
            } else {
                s.append("[");
            }
            s.append(String.valueOf(-Polyhedron.getValue(lower)));
            s.append(",");
            s.append(String.valueOf(Polyhedron.getValue(upper)));
            if (Polyhedron.isStrict(upper)) {
                s.append(")");
            } else {
                s.append("]");
            }
        }
    }

    private void appendConstraint(int i, int j, int[][] dbm, List<String> dst) {
        assert (i != j);
        StringBuilder s = new StringBuilder();
        int lower = dbm[j][i];
        int upper = dbm[i][j];
        if (lower == Constraint.MAXBOUND && upper == Constraint.MAXBOUND) {
            return;
        }
        String iname = this.getClockName(i);
        String jname = this.getClockName(j);
        if (i == 0) {
            s.append(jname);
            this.appendInterval(upper, lower, s);
        } else if (j == 0) {
            s.append(iname);
            this.appendInterval(lower, upper, s);
        } else if (Polyhedron.getValue(lower) == 0 && Polyhedron.getValue(upper) == 0) {
            s.append(iname).append(" = ").append(jname);
        } else if (Polyhedron.getValue(upper) == 0 && lower == Constraint.MAXBOUND) {
            s.append(iname).append(this.lt(upper)).append(jname);
        } else if (Polyhedron.getValue(lower) == 0 && upper == Constraint.MAXBOUND) {
            s.append(iname).append(this.gt(lower)).append(jname);
        } else if (lower == Constraint.MAXBOUND) {
            s.append(iname).append(" - ").append(jname).append(this.lt(upper)).append(Polyhedron.getValue(upper));
        } else if (upper == Constraint.MAXBOUND) {
            s.append(jname).append(" - ").append(iname).append(this.lt(lower)).append(Polyhedron.getValue(lower));
        } else if (Polyhedron.getValue(upper) < 0) {
            s.append(jname).append(" - ").append(iname);
            this.appendInterval(upper, lower, s);
        } else {
            s.append(iname).append(" - ").append(jname);
            this.appendInterval(lower, upper, s);
        }
        dst.add(s.toString());
    }

    public void getAllConstraints(List<String> result) {
        int size = this.system.getNoOfClocks();
        int[][] dbm = new int[size][size];
        this.computeCanonicalDBM(dbm);
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.appendConstraint(i, j, dbm, result);
            }
        }
    }

    public void getSufficientConstraints(List<String> result) {
        int size = this.system.getNoOfClocks();
        int[][] dbm = new int[size][size];
        this.computeCanonicalDBM(dbm);
        for (int j = 1; j < size; ++j) {
            this.appendConstraint(0, j, dbm, result);
        }
        for (Constraint c : this.constraintList) {
            if (dbm[c.i][c.j] >= Constraint.MAXBOUND || c.i <= 0 || c.j <= 0) continue;
            this.appendConstraint(c.i, c.j, dbm, result);
            int n = Constraint.MAXBOUND;
            dbm[c.j][c.i] = n;
            dbm[c.i][c.j] = n;
        }
    }

    public void addStrictConstraint(int i, int j, int bound) {
        this.constraintList.add(new Constraint(i, j, 2 * bound));
    }

    public void addNonStrictConstraint(int i, int j, int bound) {
        this.constraintList.add(new Constraint(i, j, 2 * bound + 1));
    }

    public void add(int i, int j, int bound) {
        this.constraintList.add(new Constraint(i, j, bound));
    }

    public void trim() {
        this.constraintList.trimToSize();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Polyhedron p = (Polyhedron)obj;
        return this.system == p.system && this.constraintList.equals(p.constraintList);
    }
}

