/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.freehep.graphicsio.swf.ColorXform;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class ButtonRecord {
    public static final int UP = 1;
    public static final int OVER = 2;
    public static final int DOWN = 4;
    public static final int HIT = 8;
    private boolean hitTest;
    private boolean down;
    private boolean over;
    private boolean up;
    private int id;
    private int depth;
    private AffineTransform matrix;
    private ColorXform cxform;

    public ButtonRecord(boolean hitTest, boolean down, boolean over, boolean up, int id, int depth, AffineTransform matrix, ColorXform cxform) {
        this.hitTest = hitTest;
        this.down = down;
        this.over = over;
        this.up = up;
        this.id = id;
        this.depth = depth;
        this.matrix = matrix;
        this.cxform = cxform;
    }

    public ButtonRecord(boolean hitTest, boolean down, boolean over, boolean up, int id, int depth, AffineTransform matrix) {
        this(hitTest, down, over, up, id, depth, matrix, null);
    }

    public ButtonRecord(SWFInputStream input, boolean hasColorXform) throws IOException {
        int reserved = (int)input.readUBits(4);
        this.hitTest = input.readBitFlag();
        this.down = input.readBitFlag();
        this.over = input.readBitFlag();
        this.up = input.readBitFlag();
        if (this.isEndRecord()) {
            return;
        }
        this.id = input.readUnsignedShort();
        this.depth = input.readUnsignedShort();
        this.matrix = input.readMatrix();
        if (hasColorXform) {
            this.cxform = new ColorXform(input, true);
        }
    }

    public void write(SWFOutputStream swf) throws IOException {
        swf.writeUBits(0L, 4);
        swf.writeBitFlag(this.hitTest);
        swf.writeBitFlag(this.down);
        swf.writeBitFlag(this.over);
        swf.writeBitFlag(this.up);
        swf.writeUnsignedShort(this.id);
        swf.writeUnsignedShort(this.depth);
        swf.writeMatrix(this.matrix);
        if (this.cxform != null) {
            this.cxform.write(swf, true);
        }
    }

    public boolean isEndRecord() {
        return !this.hitTest && !this.down && !this.over && !this.up;
    }

    public String toString() {
        return "ButtonRecord char:" + this.id + " depth:" + this.depth + " " + this.matrix + " " + (this.cxform != null ? "" + this.cxform : "");
    }
}

