/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.engine.ProtocolException;
import com.uppaal.gui.Main;
import com.uppaal.gui.ModePanel;
import com.uppaal.gui.SystemInspector;
import com.uppaal.model.core2.Constants;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.Process;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.Transition;
import com.uppaal.model.system.UppaalSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Simulator
extends ew
implements Constants {
    private static ResourceBundle locale = ResourceBundle.getBundle("locale.Simulator");
    private static final int DIST = 5;
    private SystemInspector inspector;
    private q[] processDisplayPanel = new q[0];
    private JPanel mainArea;
    private ModePanel innerPanel;
    private JList choiceList;
    private JList variables;
    private JList traceList;
    private JTextField fileName;
    private JToggleButton randomButton;
    private JToggleButton replayButton;
    private JSlider slider;
    private bl msc;
    private ListSelectionModel selection;
    private Timer caller;
    private dp traceFile;
    private dp psFile;
    private boolean showFullDBM = false;
    private boolean[] visible;
    private int noOfProcesses;
    private ez system;
    private SystemState currentState;
    private SystemState visibleState;
    private cv choices;
    private bt updater;
    private B trace;
    private dh coverage = null;
    private cJ covRegistry = new cJ();
    private boolean ignore = false;
    private Dimension oldDim;
    private int last_selected_trans = -1;
    public AbstractAction viewProcessesAction = new bu(this);
    public AbstractAction viewVariablesAction = new bv(this);
    public AbstractAction viewFullDBMAction = new bw(this);
    public AbstractAction selectPrevAction = new bx(this);
    public AbstractAction selectNextAction = new by(this);
    public AbstractAction stepAction = new bz(this);
    public AbstractAction toggleAction = new bA(this);
    public AbstractAction prevAction = new bC(this);
    public AbstractAction nextAction = new bf(this);
    public AbstractAction firstAction = new Q(this);
    public AbstractAction lastAction = new S(this);
    public AbstractAction replayAction = new T(this);
    public AbstractAction randomAction = new U(this);
    public AbstractAction loadTraceAction = new I(this);
    public AbstractAction saveTraceAction = new K(this);
    public AbstractAction exportAction = new M(this);
    public AbstractAction exportSelectionAction = new O(this);
    public AbstractAction markVisitedAction = new W(this);
    public AbstractAction coverageAction = new V(this);
    private boolean doUpdateChoices = false;
    private boolean doSelectChoice = false;
    private boolean doUpdateView = false;
    private boolean doUpdateButtons = false;
    private boolean doRandomStep = false;
    private boolean doReplayStep = false;
    private boolean updating = false;
    private boolean updated = true;

    public Simulator(SystemInspector systemInspector, ez ez2) throws Exception {
        this.inspector = systemInspector;
        this.system = ez2;
        this.c(true);
        this.choices = new cv(new Vector());
        this.updater = new bt(this);
        this.trace = new B();
        this.trace.a = this.coverage;
        this.trace.a(this.covRegistry);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectPrev", this.selectPrevAction);
        actionMap.put("selectNext", this.selectNextAction);
        actionMap.put("step", this.stepAction);
        actionMap.put("toggle", this.toggleAction);
        actionMap.put("prev", this.prevAction);
        actionMap.put("next", this.nextAction);
        actionMap.put("first", this.firstAction);
        actionMap.put("last", this.lastAction);
        actionMap.put("replay", this.replayAction);
        actionMap.put("random", this.randomAction);
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("Z"), "selectPrev");
        inputMap.put(KeyStroke.getKeyStroke("X"), "selectNext");
        inputMap.put(KeyStroke.getKeyStroke("Q"), "prev");
        inputMap.put(KeyStroke.getKeyStroke("A"), "next");
        inputMap.put(KeyStroke.getKeyStroke("P"), "replay");
        inputMap.put(KeyStroke.getKeyStroke("R"), "random");
        inputMap.put(KeyStroke.getKeyStroke("F"), "first");
        inputMap.put(KeyStroke.getKeyStroke("L"), "last");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "step");
        inputMap.put(KeyStroke.getKeyStroke("SPACE"), "toggle");
        cj cj2 = new cj(this);
        cj2.insert("xml/Simulator.xml", this);
        this.selection = this.traceList.getSelectionModel();
        this.msc = new bl(this.system, this.trace, this.selection);
        ((JSplitPane)cj2.find("mainSplit")).setRightComponent(this.msc);
        JScrollPane jScrollPane = (JScrollPane)cj2.find("scrollPane");
        jScrollPane.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(32);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(32);
        this.mainArea.setBackground(PROCESS_FILL_COL);
        this.mainArea.setLayout(new dk(0, 5, 5));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(60, new JLabel(locale.getString("s_slider_fast"), 4));
        ((Dictionary)hashtable).put(120, new JLabel(locale.getString("s_slider_slow"), 2));
        this.slider.setLabelTable(hashtable);
        y y2 = new y(this);
        this.traceList.setCellRenderer(y2);
        this.traceList.setFixedCellHeight(y2.getPreferredSize().height);
        this.traceList.setModel(this.trace);
        this.traceList.setSelectionMode(1);
        this.choiceList.setCellRenderer(new F(this));
        this.msc.setComponentPopupMenu((JPopupMenu)cj2.render("xml/MSCPopupMenu.xml"));
        this.traceFile = new dp(this.inspector);
        this.traceFile.a("xtr", "UPPAAL Trace File", true);
        this.system.addObserver(new ao(this));
        this.choiceList.addListSelectionListener(new af(this));
        this.choiceList.addMouseListener(new ad(this));
        this.traceList.addListSelectionListener(new ab(this));
        this.slider.addChangeListener(new aa(this));
        this.f();
    }

    private UppaalSystem a() {
        return (UppaalSystem)this.system.a;
    }

    public final void a(String string) {
        int n2 = this.a().getProcessIndex(string);
        if (n2 > -1) {
            this.processDisplayPanel[n2].setVisible(false);
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    public final void a(Vector vector, int n2) {
        this.trace.a(vector, n2);
        this.last_selected_trans = 0;
        this.covRegistry.c(this.trace.a(0));
        this.a(this.trace.a());
        this.l();
    }

    public final void b_() {
        q[] qArray = this.processDisplayPanel;
        int n2 = this.processDisplayPanel.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            q q2 = qArray[i2];
            q2.a();
        }
        this.mainArea.revalidate();
    }

    public final void c_() {
        q[] qArray = this.processDisplayPanel;
        int n2 = this.processDisplayPanel.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            q q2 = qArray[i2];
            q2.b();
        }
        this.mainArea.revalidate();
    }

    public final void a(double d2) {
        q[] qArray = this.processDisplayPanel;
        int n2 = this.processDisplayPanel.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            q q2 = qArray[i2];
            q2.a(d2);
        }
        this.mainArea.revalidate();
    }

    public final double[] a() {
        double[] dArray = new double[this.processDisplayPanel.length];
        for (int i2 = 0; i2 < this.processDisplayPanel.length; ++i2) {
            dArray[i2] = this.processDisplayPanel[i2].a();
        }
        return dArray;
    }

    private void a(double[] dArray) {
        if (dArray.length == this.processDisplayPanel.length) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.processDisplayPanel[i2].a(dArray[i2]);
            }
        }
    }

    private void d() {
        String[] stringArray = new String[this.noOfProcesses];
        boolean[] blArray = new boolean[this.noOfProcesses];
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            stringArray[i2] = this.a().getProcess(i2).getName();
            blArray[i2] = this.processDisplayPanel[i2].isVisible();
        }
        if (g.a(this.inspector, locale.getString("s_visibleProcesses"), stringArray, blArray)) {
            this.a(blArray);
        }
    }

    private void e() {
        int n2 = this.a().getNoOfVariables();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.a().getVariableName(i2);
        }
        if (g.a((Frame)this.getTopLevelAncestor(), locale.getString("s_visibleVariables"), stringArray, this.visible)) {
            this.g();
        }
    }

    private void a(boolean[] blArray) {
        if (blArray.length == this.processDisplayPanel.length) {
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                this.processDisplayPanel[i2].setVisible(blArray[i2]);
            }
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    private boolean[] a() {
        boolean[] blArray = new boolean[this.noOfProcesses];
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            blArray[i2] = this.processDisplayPanel[i2].isVisible();
        }
        return blArray;
    }

    private void f() {
        double[] dArray = this.a();
        boolean[] blArray = this.a();
        UppaalSystem uppaalSystem = this.a();
        this.trace.a((SystemState)null);
        this.traceList.clearSelection();
        this.mainArea.removeAll();
        this.noOfProcesses = 0;
        this.processDisplayPanel = new q[0];
        this.visible = null;
        this.l();
        this.viewVariablesAction.setEnabled(uppaalSystem != null);
        this.viewFullDBMAction.setEnabled(uppaalSystem != null);
        this.viewProcessesAction.setEnabled(uppaalSystem != null);
        this.markVisitedAction.setEnabled(uppaalSystem != null);
        if (uppaalSystem != null) {
            int n2;
            this.noOfProcesses = uppaalSystem.getNoOfProcesses();
            this.processDisplayPanel = new q[this.noOfProcesses];
            this.covRegistry.a(this.noOfProcesses);
            for (n2 = 0; n2 < this.noOfProcesses; ++n2) {
                Process process = uppaalSystem.getProcess(n2);
                this.processDisplayPanel[n2] = new q(this, process.getName(), process.getTranslator());
                this.mainArea.add(this.processDisplayPanel[n2]);
                this.processDisplayPanel[n2].a(process.getTemplate());
                this.covRegistry.a(n2, this.processDisplayPanel[n2].a);
            }
            n2 = uppaalSystem.getNoOfVariables();
            if (this.visible == null || n2 != this.visible.length) {
                this.visible = new boolean[n2];
            }
            while (n2-- > 0) {
                this.visible[n2] = true;
            }
            EventQueue.invokeLater(new al(this, uppaalSystem));
        }
        this.loadTraceAction.setEnabled(uppaalSystem != null);
        this.saveTraceAction.setEnabled(uppaalSystem != null);
        if (this.a()) {
            this.a(0.75);
            this.mainArea.scrollRectToVisible(new Rectangle());
        } else {
            if (dArray != null) {
                this.a(dArray);
            }
            if (blArray != null) {
                this.a(blArray);
            }
            this.mainArea.revalidate();
        }
        this.repaint();
    }

    private boolean a() {
        boolean bl2 = this.oldDim != null && !this.oldDim.equals(this.mainArea.getPreferredSize());
        this.oldDim = this.mainArea.getPreferredSize();
        return bl2;
    }

    private Transition a() {
        int n2 = this.choiceList.getSelectedIndex();
        if (n2 >= 0 && n2 < this.choices.getSize()) {
            return this.choices.a(n2);
        }
        return null;
    }

    private SystemState a() {
        int n2 = this.a();
        if (n2 >= 0 && n2 < this.trace.getSize()) {
            if (B.b(n2)) {
                --n2;
            }
            return (SystemState)this.trace.getElementAt(n2);
        }
        return null;
    }

    private void a(Vector vector) {
        this.choices = new cv(vector);
        this.choiceList.clearSelection();
        this.choiceList.setModel(this.choices);
    }

    private void g() {
        Vector<String> vector = new Vector<String>();
        if (this.visibleState != null) {
            int[] nArray = this.visibleState.getVariables();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (this.visible != null && !this.visible[i2]) continue;
                vector.add(this.a().getVariableName(i2) + " = " + nArray[i2]);
            }
            Polyhedron polyhedron = this.visibleState.getPolyhedron();
            if (this.showFullDBM) {
                polyhedron.getAllConstraints(vector);
            } else {
                polyhedron.getSufficientConstraints(vector);
            }
        }
        this.variables.setListData(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(Transition transition) {
        int n2 = this.a();
        if (n2 >= 0 && !this.trace.d(n2) && !Main.choiceError.a(locale.getString("s_overwriteWarning"))) {
            return false;
        }
        if (B.b(n2)) {
            --n2;
        }
        this.ignore = true;
        try {
            this.trace.a(n2, transition);
        }
        finally {
            this.ignore = false;
        }
        this.a(this.trace.a());
        return true;
    }

    private int a() {
        return this.traceList.getLeadSelectionIndex();
    }

    private void a(int n2) {
        this.traceList.setSelectedIndex(n2);
        this.traceList.ensureIndexIsVisible(n2);
        this.traceList.revalidate();
    }

    private int b() {
        return (int)Math.pow(2.0, (double)this.slider.getValue() / 10.0);
    }

    private int c() {
        Vector vector = null;
        if (this.coverage == null) {
            vector = new Vector();
            for (int i2 = 0; i2 < this.choices.getSize(); ++i2) {
                Transition transition = this.choices.a(i2);
                if (transition.getTarget() == null) continue;
                vector.add(i2);
            }
        } else {
            vector = this.coverage.a(this.choices.a);
        }
        if (vector.size() == 0) {
            return -1;
        }
        return (Integer)vector.get((int)((double)vector.size() * Math.random()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void h() {
        try {
            if (this.traceFile.a(locale.getString("s_openTraceFile"))) {
                this.fileName.setText(this.traceFile.a());
                FileInputStream fileInputStream = this.traceFile.a();
                if (fileInputStream == null) {
                    throw new FileNotFoundException();
                }
                try {
                    this.trace.a(this.a(), fileInputStream);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
                this.a(0);
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.infoError.a(locale.getString("s_fileNotFoundError") + " " + this.traceFile.a());
            return;
        }
        catch (IOException iOException) {
            Main.infoError.a(iOException.getMessage());
            return;
        }
        catch (ProtocolException protocolException) {
            Main.infoError.a(locale.getString("s_notValidTraceFileError"));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void i() {
        block8: {
            try {
                if (this.traceFile.a(locale.getString("s_saveTraceFile"), "xtr")) {
                    this.fileName.setText(this.traceFile.a());
                    FileOutputStream fileOutputStream = this.traceFile.a();
                    if (fileOutputStream == null) {
                        throw new FileNotFoundException();
                    }
                    try {
                        this.trace.a(fileOutputStream);
                        break block8;
                    }
                    finally {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Main.infoError.a(locale.getString("s_fileNotFoundError") + " " + fileNotFoundException.getMessage());
                return;
            }
            catch (IOException iOException) {
                Main.infoError.a(iOException.getMessage());
            }
        }
    }

    public final void j() {
        this.viewProcessesAction.setEnabled(true);
        this.viewVariablesAction.setEnabled(true);
        this.viewFullDBMAction.setEnabled(true);
    }

    public final void k() {
        this.viewProcessesAction.setEnabled(false);
        this.viewVariablesAction.setEnabled(false);
        this.viewFullDBMAction.setEnabled(false);
    }

    private void l() {
        this.doUpdateChoices = true;
        this.doSelectChoice = true;
        this.doUpdateView = true;
        this.doUpdateButtons = true;
        this.o();
    }

    private void m() {
        this.doSelectChoice = true;
        this.doUpdateChoices = true;
        this.doUpdateButtons = true;
        this.doUpdateView = true;
        this.o();
    }

    private void n() {
        this.doUpdateView = true;
        this.doUpdateButtons = true;
        this.o();
    }

    private void o() {
        if (!this.updating) {
            this.updating = true;
            EventQueue.invokeLater(new ai(this));
        }
    }

    private void p() {
        int n2;
        int n3;
        if (this.doRandomStep && this.updated) {
            n3 = this.c();
            if (n3 == -1 || !this.a(this.choices.a(n3))) {
                this.s();
            }
            this.doRandomStep = false;
        }
        if (this.doReplayStep) {
            if (!this.trace.d(this.a())) {
                if (B.a(this.a()) || this.a() == this.trace.getSize() - 2) {
                    this.a(this.a() + 1);
                } else {
                    this.a(this.a() + 2);
                }
            }
            if (this.trace.d(this.a())) {
                this.s();
            }
            this.doReplayStep = false;
        }
        if (this.doUpdateChoices) {
            SystemState systemState = this.a();
            if (this.currentState != systemState) {
                this.currentState = systemState;
                this.a(new Vector());
                if (systemState != null) {
                    this.updated = false;
                    this.updater.a();
                } else {
                    this.updated = true;
                }
            }
            this.doUpdateChoices = false;
            this.doSelectChoice = true;
        }
        if (this.doSelectChoice && this.updated) {
            n3 = this.a();
            if (n3 >= 0 && n3 < this.trace.getSize()) {
                n2 = -1;
                if (this.trace.d(n3)) {
                    n2 = this.c();
                } else if (!B.a(n3)) {
                    n2 = this.choices.a(this.trace.a(n3));
                }
                if (n2 >= 0 && n2 < this.choices.getSize()) {
                    this.choiceList.setSelectedIndex(n2);
                    this.choiceList.ensureIndexIsVisible(n2);
                    this.choiceList.revalidate();
                } else {
                    this.choiceList.clearSelection();
                }
            }
            this.doSelectChoice = false;
            this.doUpdateView = true;
            this.doUpdateButtons = true;
        }
        if (this.doUpdateView) {
            q q2;
            int n4;
            int n5;
            q[] qArray;
            SystemState systemState;
            n2 = this.choiceList.getSelectedIndex();
            Transition transition = n2 >= 0 && n2 < this.choices.getSize() ? this.choices.a(n2) : null;
            if (transition != null) {
                systemState = transition.getSource();
                this.variables.setForeground(new Color(49, 101, 255));
            } else {
                systemState = this.currentState;
                this.variables.setForeground(Color.BLACK);
            }
            if (this.visibleState != systemState) {
                this.visibleState = systemState;
                if (this.visibleState != null) {
                    qArray = systemState.getLocationVector();
                    for (n5 = 0; n5 < this.noOfProcesses; ++n5) {
                        this.processDisplayPanel[n5].a(qArray[n5].getLocation());
                    }
                } else {
                    qArray = this.processDisplayPanel;
                    n5 = this.processDisplayPanel.length;
                    for (n4 = 0; n4 < n5; ++n4) {
                        q2 = qArray[n4];
                        q2.a((Location)null);
                    }
                }
                this.g();
            }
            qArray = this.processDisplayPanel;
            n5 = this.processDisplayPanel.length;
            for (n4 = 0; n4 < n5; ++n4) {
                q2 = qArray[n4];
                q2.a((Edge)null);
            }
            if (transition != null) {
                qArray = transition.getEdges();
                n5 = qArray.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    q2 = qArray[n4];
                    this.processDisplayPanel[q2.getProcess().getIndex()].a(q2.getEdge());
                }
            }
            if (this.trace.getSize() > 0) {
                int n6 = this.traceList.getLeadSelectionIndex();
                if ((n6 = (n6 | 1) - 1) > this.last_selected_trans) {
                    for (n5 = this.last_selected_trans + 2; n5 <= n6; n5 += 2) {
                        this.covRegistry.c(this.trace.a(n5));
                    }
                } else if (n6 < this.last_selected_trans) {
                    for (n5 = n6 + 2; n5 <= this.last_selected_trans; n5 += 2) {
                        if (n5 >= this.trace.getSize()) continue;
                        this.covRegistry.d(this.trace.a(n5));
                    }
                }
                this.last_selected_trans = n6;
            } else {
                this.last_selected_trans = -1;
            }
            this.doUpdateView = false;
        }
        if (this.doUpdateButtons) {
            int n7 = this.a();
            n2 = this.choiceList.getSelectedIndex();
            this.prevAction.setEnabled(n7 > 0 && this.caller == null);
            this.nextAction.setEnabled(!this.trace.d(n7) && this.caller == null);
            this.stepAction.setEnabled(n2 >= 0 && n2 < this.choices.getSize());
            this.doUpdateButtons = false;
        }
    }

    private void q() {
        if (this.caller == null) {
            this.replayAction.setEnabled(true);
            this.randomAction.setEnabled(false);
            this.loadTraceAction.setEnabled(false);
            this.saveTraceAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.inspector.verifier.setEnabled(false);
            this.caller = new Timer(this.b(), new bi(this, null));
            this.caller.start();
            this.replayButton.setSelected(true);
        }
    }

    private void r() {
        if (this.caller == null) {
            int n2 = this.b();
            this.replayAction.setEnabled(false);
            this.randomAction.setEnabled(true);
            this.loadTraceAction.setEnabled(false);
            this.saveTraceAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.inspector.verifier.setEnabled(false);
            this.caller = new Timer(n2, new cs(this, null));
            this.caller.start();
            this.randomButton.setSelected(true);
        }
    }

    private void s() {
        if (this.caller != null) {
            this.caller.stop();
            this.caller = null;
            this.stepAction.setEnabled(this.a() != null);
            this.inspector.verifier.setEnabled(true);
            this.randomAction.setEnabled(true);
            this.replayAction.setEnabled(true);
            this.loadTraceAction.setEnabled(this.system != null);
            this.saveTraceAction.setEnabled(this.a() != null);
            this.replayButton.setSelected(false);
            this.randomButton.setSelected(false);
            this.doUpdateButtons = true;
            this.o();
        }
    }

    public static /* synthetic */ void a(Simulator simulator) {
        simulator.d();
    }

    public static /* synthetic */ void b(Simulator simulator) {
        simulator.e();
    }

    public static /* synthetic */ boolean a(Simulator simulator, boolean bl2) {
        simulator.showFullDBM = bl2;
        return simulator.showFullDBM;
    }

    public static /* synthetic */ boolean a(Simulator simulator) {
        return simulator.showFullDBM;
    }

    public static /* synthetic */ void c(Simulator simulator) {
        simulator.g();
    }

    public static /* synthetic */ JList a(Simulator simulator) {
        return simulator.choiceList;
    }

    public static /* synthetic */ cv a(Simulator simulator) {
        return simulator.choices;
    }

    public static /* synthetic */ Transition a(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ SystemInspector a(Simulator simulator) {
        return simulator.inspector;
    }

    public static /* synthetic */ boolean a(Simulator simulator, Transition transition) {
        return simulator.a(transition);
    }

    public static /* synthetic */ int a(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ B a(Simulator simulator) {
        return simulator.trace;
    }

    public static /* synthetic */ void a(Simulator simulator, int n2) {
        simulator.a(n2);
    }

    public static /* synthetic */ Timer a(Simulator simulator) {
        return simulator.caller;
    }

    public static /* synthetic */ void d(Simulator simulator) {
        simulator.q();
    }

    public static /* synthetic */ void e(Simulator simulator) {
        simulator.s();
    }

    public static /* synthetic */ void f(Simulator simulator) {
        simulator.r();
    }

    public static /* synthetic */ void g(Simulator simulator) {
        simulator.h();
    }

    public static /* synthetic */ void h(Simulator simulator) {
        simulator.i();
    }

    public static /* synthetic */ bl a(Simulator simulator) {
        return simulator.msc;
    }

    public static /* synthetic */ cJ a(Simulator simulator) {
        return simulator.covRegistry;
    }

    public static /* synthetic */ JList b(Simulator simulator) {
        return simulator.traceList;
    }

    public static /* synthetic */ int a(Simulator simulator, int n2) {
        simulator.last_selected_trans = n2;
        return simulator.last_selected_trans;
    }

    public static /* synthetic */ JPanel a(Simulator simulator) {
        return simulator.mainArea;
    }

    public static /* synthetic */ int b(Simulator simulator) {
        return simulator.noOfProcesses;
    }

    public static /* synthetic */ UppaalSystem a(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ q[] a(Simulator simulator) {
        return simulator.processDisplayPanel;
    }

    public static /* synthetic */ void i(Simulator simulator) {
        simulator.f();
    }

    public static /* synthetic */ void j(Simulator simulator) {
        simulator.n();
    }

    public static /* synthetic */ void k(Simulator simulator) {
        simulator.m();
    }

    public static /* synthetic */ int c(Simulator simulator) {
        return simulator.b();
    }

    public static /* synthetic */ dh a(Simulator simulator) {
        return simulator.coverage;
    }

    public static /* synthetic */ void l(Simulator simulator) {
        simulator.p();
    }

    public static /* synthetic */ boolean b(Simulator simulator, boolean bl2) {
        simulator.updating = bl2;
        return simulator.updating;
    }

    public static /* synthetic */ boolean c(Simulator simulator, boolean bl2) {
        simulator.doReplayStep = bl2;
        return simulator.doReplayStep;
    }

    public static /* synthetic */ void m(Simulator simulator) {
        simulator.o();
    }

    public static /* synthetic */ boolean d(Simulator simulator, boolean bl2) {
        simulator.doRandomStep = bl2;
        return simulator.doRandomStep;
    }

    public static /* synthetic */ ResourceBundle a() {
        return locale;
    }

    public static /* synthetic */ SystemState a(Simulator simulator) {
        return simulator.currentState;
    }

    public static /* synthetic */ ez a(Simulator simulator) {
        return simulator.system;
    }

    public static /* synthetic */ boolean e(Simulator simulator, boolean bl2) {
        simulator.updated = bl2;
        return simulator.updated;
    }

    public static /* synthetic */ void a(Simulator simulator, Vector vector) {
        simulator.a(vector);
    }
}

