/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.CompoundCommand;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.SetPropertyCommand;
import com.uppaal.model.core2.Template;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConvertSyntaxVisitor
extends AbstractVisitor {
    private Vector<Command> commands = new Vector();

    private void set(Element element, String property, String value) {
        this.commands.add(new SetPropertyCommand(element, property, value));
    }

    private String fixDeclarations(String s) {
        s = s.replaceAll(":=", "=");
        s = s.replaceAll("const\\s+(\\w+)\\s*((\\[[^\\]]*\\])*)\\s*", "const int $1$2 = ");
        int i = 0;
        while ((i = s.indexOf("const int", i)) > -1) {
            int cnt = 0;
            while (i < s.length() && s.charAt(i) != ';') {
                switch (s.charAt(i)) {
                    case '[': 
                    case '{': {
                        ++cnt;
                        break;
                    }
                    case ']': 
                    case '}': {
                        --cnt;
                        break;
                    }
                    case ',': {
                        if (cnt != 0) break;
                        StringBuffer b = new StringBuffer();
                        Matcher m = Pattern.compile("(\\s*(\\w+)+)\\s*((\\[[^\\]]*\\])*)\\s*").matcher(s);
                        m.find(++i);
                        m.appendReplacement(b, "$1$3 = ");
                        m.appendTail(b);
                        s = b.toString();
                    }
                }
                ++i;
            }
        }
        return s;
    }

    public void visitDocument(Document document) throws Exception {
        Property declaration = document.getLocalProperty("declaration");
        if (declaration != null) {
            String value = (String)declaration.getValue();
            this.set(document, "declaration", this.fixDeclarations(value));
        }
        super.visitDocument(document);
        Property system = document.getLocalProperty("system");
        if (system != null) {
            String value = (String)system.getValue();
            this.set(document, "system", this.fixDeclarations(value));
        }
        Object[] array = new Command[this.commands.size()];
        this.commands.copyInto(array);
        document.execute((Command)new CompoundCommand((Command[])array));
    }

    public void visitTemplate(Template template) throws Exception {
        Property parameter;
        Property declaration = template.getLocalProperty("declaration");
        if (declaration != null) {
            String value = (String)declaration.getValue();
            this.set(template, "declaration", this.fixDeclarations(value));
        }
        if ((parameter = template.getLocalProperty("parameter")) != null) {
            String s;
            String value = (String)parameter.getValue();
            while (!(s = value).equals(value = s.replaceFirst("((\\w+(\\s*\\[[^\\]]*\\]\\s*|\\s+))+)(\\w+(\\[[^\\]]*\\])*)\\s*,\\s*", "$1$4; $1"))) {
            }
            value = value.replaceAll("(int(\\[[^\\]]*\\])?)", "$1&");
            value = value.replaceAll("(^|\\W)const\\s+", "$1const int ");
            value = value.replaceAll("(^|\\W)clock\\s+", "$1clock &");
            value = value.replaceAll("(^|\\W)chan\\s+", "$1chan &");
            value = value.replaceAll(";", ",");
            this.set(template, "parameter", value);
        }
        super.visitTemplate(template);
    }

    public void visitLocation(Location location) throws Exception {
        Property invariant = location.getLocalProperty("invariant");
        if (invariant != null) {
            String value = (String)invariant.getValue();
            this.set(location, "invariant", value.replaceAll("\\s?,\\s?", " and "));
        }
    }

    public void visitEdge(Edge edge) throws Exception {
        Property assignment;
        Property guard = edge.getLocalProperty("guard");
        if (guard != null) {
            String value = (String)guard.getValue();
            this.set(edge, "guard", value.replaceAll("\\s?,\\s?", " and "));
        }
        if ((assignment = edge.getLocalProperty("assignment")) != null) {
            String value = (String)assignment.getValue();
            this.set(edge, "assignment", value.replaceAll(":=", "="));
        }
    }
}

