/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.system.EmptyTranslator;
import com.uppaal.model.system.Translator;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class BoundCalc
extends AbstractVisitor {
    private double minx;
    private double miny;
    private double maxx;
    private double maxy;
    private Translator translator;
    private double smooth = 1.0;
    final double lHeight = 14.0;
    final double locRadius = 4.5;
    final double nailRadius = 2.0;
    FontMetrics plainMetrics = null;
    FontMetrics boldMetrics = null;

    public double plainWidth(String s) {
        return this.plainMetrics.stringWidth(s) - 10;
    }

    public double boldWidth(String s) {
        return this.boldMetrics.stringWidth(s) - 10;
    }

    public BoundCalc() {
        this(new EmptyTranslator());
    }

    public BoundCalc(Translator aTranslator) {
        this.translator = aTranslator;
        this.minx = Double.POSITIVE_INFINITY;
        this.miny = Double.POSITIVE_INFINITY;
        this.maxx = Double.NEGATIVE_INFINITY;
        this.maxy = Double.NEGATIVE_INFINITY;
        BufferedImage i = new BufferedImage(1, 1, 1);
        Graphics2D g = i.createGraphics();
        this.plainMetrics = g.getFontMetrics(new Font("Helvetica", 0, 14));
        this.boldMetrics = g.getFontMetrics(new Font("Helvetica", 1, 14));
    }

    private void draw(Property property, boolean bold) throws IOException {
        int j = 0;
        int head = 0;
        String line = this.translator.translate(property.getValue().toString());
        if (line.length() > 0) {
            double yy;
            double xx;
            String text;
            int tail;
            int x = (Integer)property.getPropertyValue("x");
            int y = (Integer)property.getPropertyValue("y");
            if (this.minx > (double)(x + 8)) {
                this.minx = x + 8;
            }
            if (this.miny > (double)(y + 8)) {
                this.miny = y + 8;
            }
            if (this.maxx < (double)x) {
                this.maxx = x;
            }
            if (this.maxy < (double)y) {
                this.maxy = y;
            }
            while (line.substring(head).indexOf("\n") != -1) {
                tail = head + line.substring(head).indexOf("\n");
                text = line.substring(head, tail);
                if (text.length() > 0) {
                    xx = x;
                    xx = bold ? (xx += this.boldWidth(text)) : (xx += this.plainWidth(text));
                    if (this.maxx < xx) {
                        this.maxx = xx;
                    }
                    if (this.maxy < (yy = (double)y + (double)j * 14.0 + 2.0)) {
                        this.maxy = yy;
                    }
                }
                ++j;
                head = tail + 1;
            }
            tail = line.length();
            text = line.substring(head, tail);
            if (text.length() > 0) {
                xx = x;
                xx = bold ? (xx += this.boldWidth(text)) : (xx += this.plainWidth(text));
                if (this.maxx < xx) {
                    this.maxx = xx;
                }
                if (this.maxy < (yy = (double)y + (double)j * 14.0 + 2.0)) {
                    this.maxy = yy;
                }
            }
        }
    }

    protected void draw(Element element, double margin) {
        int x = (Integer)element.getPropertyValue("x");
        int y = (Integer)element.getPropertyValue("y");
        if (this.minx > (double)x - margin) {
            this.minx = (double)x - margin;
        }
        if (this.miny > (double)y - margin) {
            this.miny = (double)y - margin;
        }
        if (this.maxx < (double)x + margin) {
            this.maxx = (double)x + margin;
        }
        if (this.maxy < (double)(y - 5)) {
            this.maxy = y - 5;
        }
    }

    private void draw(Edge edge) {
        this.draw(edge.getSource(), 4.5);
        for (Node node = edge.getFirst(); node != null; node = node.getNext()) {
            this.draw(node, 2.0);
        }
        this.draw(edge.getTarget(), 4.5);
    }

    @Override
    public void visitTemplate(Template template) throws Exception {
        template.accept(new AbstractVisitor(){

            @Override
            public void visitLocation(Location location) throws Exception {
                BoundCalc.this.visitLocation(location);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitEdge(Edge edge) throws Exception {
                BoundCalc.this.visitEdge(edge);
            }
        });
    }

    @Override
    public void visitLocation(Location location) throws Exception {
        int x = (Integer)location.getPropertyValue("x");
        int y = (Integer)location.getPropertyValue("y");
        if (this.minx > (double)x) {
            this.minx = x;
        }
        if (this.miny > (double)y) {
            this.miny = y;
        }
        if (this.maxx < (double)x) {
            this.maxx = x;
        }
        if (this.maxy < (double)(y - 2)) {
            this.maxy = y - 2;
        }
        this.draw(location.getProperty("name"), true);
        this.draw(location.getProperty("invariant"), true);
    }

    @Override
    public void visitEdge(Edge edge) throws Exception {
        this.draw(edge);
        this.draw(edge.getProperty("select"), false);
        this.draw(edge.getProperty("guard"), false);
        this.draw(edge.getProperty("synchronisation"), false);
        this.draw(edge.getProperty("assignment"), false);
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Double b = new Rectangle2D.Double(this.minx, this.miny, this.maxx - this.minx, this.maxy - this.miny + 5.0);
        return b;
    }
}

