/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTransaction;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;

public abstract class SetEndPointCommand
extends AbstractTransaction {
    protected Edge edge;
    protected Location location;
    protected Nail nail;

    public abstract Location getLocation();

    protected abstract void setLocation(Location var1);

    protected abstract void insertNail(Nail var1);

    public SetEndPointCommand(Document document, Edge edge) {
        super(document);
        this.edge = edge;
        this.location = this.getLocation();
    }

    public Nail convertToNail(int x, int y) {
        assert (this.nail == null) : "Can only convert end point to nail once.";
        assert (!this.committed) : "Cannot modify a committed command.";
        this.nail = this.edge.createNail();
        this.nail.setProperty("x", x);
        this.nail.setProperty("y", y);
        this.insertNail(this.nail);
        return this.nail;
    }

    public void moveNailTo(int x, int y) {
        assert (this.nail != null) : "Must convert to nail first.";
        assert (!this.committed) : "Cannot modify a committed command.";
        this.nail.setProperty("x", x);
        this.nail.setProperty("y", y);
    }

    public void setEndPoint(Location location) {
        assert (!this.committed) : "Cannot modify a committed command.";
        if (this.nail != null) {
            this.nail.remove();
            this.nail = null;
        }
        this.setLocation(location);
    }

    @Override
    protected void doCancel() {
        if (this.nail != null) {
            this.nail.remove();
            this.nail = null;
        }
        this.setLocation(this.location);
    }

    @Override
    protected void doExecute() {
        this.swap();
        if (this.nail != null) {
            this.insertNail(this.nail);
        }
    }

    @Override
    protected void doUndo() {
        this.swap();
        if (this.nail != null) {
            this.nail.remove();
        }
    }

    protected void swap() {
        Location tmp = this.getLocation();
        this.setLocation(this.location);
        this.location = tmp;
    }
}

