/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import java.awt.Color;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLWriter
extends AbstractVisitor {
    protected int counter;
    protected XMLStreamWriter writer;
    protected Map<Location, String> locations = new HashMap<Location, String>();
    protected String init;

    public XMLWriter(OutputStream stream) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.writer = outputFactory.createXMLStreamWriter(stream, "utf-8");
    }

    public XMLWriter(Writer writer) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.writer = outputFactory.createXMLStreamWriter(writer);
    }

    protected void writePropertyAsElement(Element element, String property, boolean optional) throws XMLStreamException {
        String value = (String)element.getPropertyValue(property);
        if (!optional || value != null && value.length() > 0) {
            this.writer.writeStartElement(property);
            this.writeAttributes(element.getProperty(property));
            if (value != null) {
                this.writer.writeCharacters(value.toString());
            }
            this.writer.writeEndElement();
        }
    }

    protected void writePropertyAsLabel(Element element, String name) throws XMLStreamException {
        String str;
        Property property = element.getProperty(name);
        if (property != null && (str = property.getValue().toString().trim()).length() > 0) {
            this.writer.writeStartElement("label");
            this.writer.writeAttribute("kind", name);
            this.writeAttributes(property);
            this.writer.writeCharacters(str);
            this.writer.writeEndElement();
        }
    }

    protected void writeAttributes(Element element) throws XMLStreamException {
        Property color;
        Object x = element.getPropertyValue("x");
        Object y = element.getPropertyValue("y");
        if (x != null && y != null) {
            this.writer.writeAttribute("x", x.toString());
            this.writer.writeAttribute("y", y.toString());
        }
        if ((color = element.getLocalProperty("color")) != null) {
            int rgb = ((Color)color.getValue()).getRGB() & 0xFFFFFF;
            String hex = String.format("#%06x", rgb);
            this.writer.writeAttribute("color", hex);
        }
    }

    protected boolean hasFlag(Element element, String property) {
        Object value = element.getPropertyValue(property);
        return value != null && (Boolean)value != false;
    }

    protected void writeFlag(Element element, String property) throws XMLStreamException {
        if (this.hasFlag(element, property)) {
            this.writer.writeEmptyElement(property);
        }
    }

    public void visitDocument(Document document) throws Exception {
        this.writer.writeStartDocument("utf-8", "1.0");
        this.writer.writeDTD("<!DOCTYPE nta PUBLIC '-//Uppaal Team//DTD Flat System 1.1//EN' 'http://www.it.uu.se/research/group/darts/uppaal/flat-1_1.dtd'>");
        this.writer.writeStartElement("nta");
        this.writePropertyAsElement(document, "declaration", true);
        super.visitDocument(document);
        this.writePropertyAsElement(document, "instantiation", true);
        this.writePropertyAsElement(document, "system", false);
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
    }

    public void visitTemplate(Template template) throws Exception {
        this.writer.writeStartElement("template");
        this.writePropertyAsElement(template, "name", false);
        this.writePropertyAsElement(template, "parameter", true);
        this.writePropertyAsElement(template, "declaration", true);
        template.accept(new AbstractVisitor(){

            public void visitLocation(Location location) throws Exception {
                location.accept(XMLWriter.this);
            }
        });
        if (this.init != null) {
            this.writer.writeEmptyElement("init");
            this.writer.writeAttribute("ref", this.init);
            this.init = null;
        }
        template.accept(new AbstractVisitor(){

            public void visitEdge(Edge edge) throws Exception {
                edge.accept(XMLWriter.this);
            }
        });
        this.writer.writeEndElement();
    }

    public void visitLocation(Location location) throws Exception {
        String id = "id" + this.counter++;
        this.writer.writeStartElement("location");
        this.writer.writeAttribute("id", id);
        this.writeAttributes(location);
        this.locations.put(location, id);
        this.writePropertyAsElement(location, "name", true);
        this.writePropertyAsLabel(location, "invariant");
        this.writePropertyAsLabel(location, "comments");
        this.writeFlag(location, "urgent");
        this.writeFlag(location, "committed");
        if (this.hasFlag(location, "init")) {
            this.init = id;
        }
        this.writer.writeEndElement();
    }

    public void visitEdge(Edge edge) throws Exception {
        this.writer.writeStartElement("transition");
        if (!edge.hasFlag("controllable")) {
            this.writer.writeAttribute("controllable", "false");
        }
        this.writeAttributes(edge);
        this.writer.writeEmptyElement("source");
        this.writer.writeAttribute("ref", this.locations.get(edge.getSource()));
        this.writer.writeEmptyElement("target");
        this.writer.writeAttribute("ref", this.locations.get(edge.getTarget()));
        this.writePropertyAsLabel(edge, "select");
        this.writePropertyAsLabel(edge, "guard");
        this.writePropertyAsLabel(edge, "synchronisation");
        this.writePropertyAsLabel(edge, "assignment");
        this.writePropertyAsLabel(edge, "comments");
        super.visitEdge(edge);
        this.writer.writeEndElement();
    }

    public void visitNail(Nail nail) throws Exception {
        this.writer.writeEmptyElement("nail");
        this.writeAttributes(nail);
    }
}

