/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.CannotRedoException;
import com.uppaal.model.core2.CannotUndoException;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.CompoundCommand;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.io2.XTAWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class Document
extends Node {
    private static AtomicInteger counter = new AtomicInteger();
    protected int version;
    protected LinkedList<Command> undoList = new LinkedList();
    protected LinkedList<Command> redoList = new LinkedList();

    public Document() {
        super(null);
        this.version = counter.incrementAndGet();
    }

    public Document(Element prototype) {
        super(prototype);
        this.version = counter.incrementAndGet();
    }

    public void execute(Command command) {
        command.setVersion(this.version);
        this.version = counter.incrementAndGet();
        this.redoList.clear();
        this.undoList.add(command);
        command.execute();
    }

    public void execute(Command ... commands) {
        this.execute((Command)new CompoundCommand(commands));
    }

    public void undo() throws CannotUndoException {
        if (this.undoList.isEmpty()) {
            throw new CannotUndoException();
        }
        Command command = this.undoList.removeLast();
        int oldVersion = this.version;
        this.version = command.getVersion();
        command.setVersion(oldVersion);
        command.undo();
        this.redoList.add(command);
    }

    public void redo() throws CannotRedoException {
        if (this.redoList.isEmpty()) {
            throw new CannotRedoException();
        }
        Command command = this.redoList.removeLast();
        int oldVersion = this.version;
        this.version = command.getVersion();
        command.setVersion(oldVersion);
        command.execute();
        this.undoList.add(command);
    }

    public int getVersion() {
        return this.version;
    }

    public Template createTemplate() {
        return new Template((Element)this.getPropertyValue("#template"));
    }

    public Template getTemplates() {
        return (Template)this.first;
    }

    public Template getTemplate(String name) {
        for (Template template = this.getTemplates(); template != null; template = (Template)template.getNext()) {
            if (!template.getPropertyValue("name").equals(name)) continue;
            return template;
        }
        return null;
    }

    public void accept(Visitor visitor) throws Exception {
        visitor.visitDocument(this);
    }

    public Document getDocument() {
        return this;
    }

    private Node getChild(Element element, int index, Class c) {
        Node child;
        if (!(element instanceof Node)) {
            return null;
        }
        for (child = ((Node)element).getFirst(); child != null && !c.isInstance(child); child = child.getNext()) {
        }
        while (child != null && index > 1) {
            while ((child = child.getNext()) != null && !c.isInstance(child)) {
            }
            --index;
        }
        return child;
    }

    public Element resolveXPath(String path) {
        Pattern pattern = Pattern.compile("(\\w+)(\\[((\\d+)|@kind=\"(\\w+)\")\\])?");
        Scanner scanner = new Scanner(path);
        Element current = this;
        while (scanner.hasNext() && current != null) {
            scanner.findInLine(pattern);
            MatchResult result = scanner.match();
            String token = result.group(1);
            String s = result.group(4);
            int index = s == null ? 1 : Integer.parseInt(s);
            String kind = result.group(5);
            if (token.equals("nta")) {
                current = this;
                continue;
            }
            if (token.equals("declaration")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("template")) {
                current = this.getChild(current, index, Template.class);
                continue;
            }
            if (token.equals("instantiation")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("system")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("name")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("parameter")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("location")) {
                current = this.getChild(current, index, Location.class);
                continue;
            }
            if (token.equals("init")) continue;
            if (token.equals("transition")) {
                current = this.getChild(current, index, Edge.class);
                continue;
            }
            if (token.equals("label")) {
                String[] kinds = new String[]{"invariant", "select", "guard", "synchronisation", "assignment"};
                if (kind != null) {
                    current = current.getLocalProperty(kind);
                    continue;
                }
                Property child = null;
                for (String k : kinds) {
                    if (!current.isPropertyLocal(k)) continue;
                    if (index == 1) {
                        child = current.getProperty(k);
                    }
                    --index;
                }
                current = child;
                continue;
            }
            if (token.equals("urgent")) {
                current = current.getProperty(token);
                continue;
            }
            if (token.equals("source") || token.equals("target")) continue;
            if (token.equals("nail")) {
                current = this.getChild(current, index, Nail.class);
                continue;
            }
            return null;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String name) throws IOException {
        block11: {
            FileOutputStream out = new FileOutputStream(name);
            try {
                String s = name.toLowerCase();
                if (s.endsWith(".xml")) {
                    this.accept(new XMLWriter(out));
                    break block11;
                }
                if (s.endsWith(".xta")) {
                    String gfxFilename = name.replaceFirst("xta$", "ugi");
                    FileOutputStream gfx = new FileOutputStream(gfxFilename);
                    try {
                        XTAWriter writer = new XTAWriter(out);
                        this.accept(writer);
                        this.accept(writer.createUGIWriter(gfx));
                        break block11;
                    }
                    finally {
                        gfx.flush();
                        gfx.close();
                    }
                }
                throw new IOException("The file extension was not recognised (Only .xml and .xta are supported).");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            finally {
                out.flush();
                out.close();
            }
        }
    }
}

