/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Constants;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.io2.BoundCalc;
import com.uppaal.model.io2.FloatPoint;
import com.uppaal.model.system.EmptyTranslator;
import com.uppaal.model.system.Translator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class PSWriter
extends AbstractVisitor
implements Constants {
    private Writer out;
    private String filename;
    private Translator translator;
    private boolean colors;
    private String version;

    public PSWriter(OutputStream stream, String filename, boolean colors, String version) {
        this(stream, filename, colors, version, new EmptyTranslator());
    }

    public PSWriter(OutputStream stream, String filename, boolean colors, String version, Translator aTranslator) {
        this.out = new OutputStreamWriter(stream);
        this.filename = filename;
        this.colors = colors;
        this.version = version;
        this.translator = aTranslator;
    }

    protected boolean hasFlag(Element element, String property) {
        Object value = element.getPropertyValue(property);
        return value != null && (Boolean)value != false;
    }

    private void generateHeader(String title, Rectangle2D bnds) throws IOException {
        this.out.write("%!PS-Adobe-3.0 EPSF-3.0\n%%Title:   " + title + "\n" + "%%Creator: " + this.version + "\n" + "%%Pages: 0\n" + "%%BoundingBox: " + (int)(bnds.getX() - 10.0) / 2 + " " + (int)(bnds.getY() - 10.0) / 2 + " " + (int)(bnds.getX() + bnds.getWidth() + 10.0) / 2 + " " + (int)(bnds.getY() + bnds.getHeight() + 10.0) / 2 + "\n" + "%%EndComments\n" + "\n" + "% Basic coordinate transformation.\n" + "0.5 0.5 scale\n" + "\n" + "% Move the origin.\n" + "0 " + (int)(2.0 * bnds.getY() + bnds.getHeight()) + " translate\n" + "\n" + "% Size of graphical elements.\n" + "/vertex-radius " + 12 + " def\n" + "/vertex-urgent-radius " + 5 + " def\n" + "/vertex-commit-radius " + 5 + " def\n" + "/vertex-init-radius " + 8 + " def\n" + "/vertex-lw 1.2 def\n" + "/edge-lw 1.0 def\n" + "\n");
        if (this.colors) {
            this.out.write("% Color setting of graphical elements.\n/black { 0 0 0 setrgbcolor } def\n/vertex-fill-col { 0.647 0.686 0.803 setrgbcolor} def\n/vertex-ol-col { black } def\n/urgent-ol-col { black } def\n/commit-ol-col { black } def\n/initial-ol-col { black } def\n/state-name-col { 0.549 0.2196 0.3882 setrgbcolor } def\n/inv-col { 0.6549 0.2588 0.6588 setrgbcolor } def\n/select-col { 0.6392 0.6588 0.2588 setrgbcolor } def\n/guard-col { 0.2588 0.6588 0.2824 setrgbcolor } def\n/sync-col { 0.2588 0.6275 0.6588 setrgbcolor } def\n/assign-col { 0.2588 0.2588 0.6588 setrgbcolor } def\n/trans-col { black } def\n\n");
        } else {
            this.out.write("% B&W&Grey setting of graphical elements.\n/black { 0 0 0 setrgbcolor } def\n/grey { .8 .8 .8 setrgbcolor } def\n/vertex-fill-col { grey } def\n/vertex-ol-col { black } def\n/urgent-ol-col { black } def\n/commit-ol-col { black } def\n/initial-ol-col { black } def\n/state-name-col { black } def\n/inv-col { state-name-col } def\n/select-col { black } def\n/guard-col { select-col } def\n/sync-col { guard-col } def\n/assign-col { guard-col } def\n/trans-col { black } def\n\n");
        }
        this.out.write("% Draw (filled) vertex at given position.\n/vertex { \n   2 copy\n   vertex-fill-col\n   newpath vertex-lw setlinewidth \n   /vertex-radius load 0 360 arc fill\n   vertex-ol-col\n   /vertex-radius load 0 360 arc stroke\n} def\n\n% Mark vertex as urgent.\n/urgent { \n   urgent-ol-col\n   newpath vertex-lw setlinewidth \n   /vertex-urgent-radius load 150 30 arc stroke \n} def\n\n% Mark vertex as committed.\n/commit { \n   commit-ol-col\n   newpath vertex-lw setlinewidth \n   /vertex-commit-radius load 50 310 arc stroke \n} def\n\n% Mark vertex as initial.\n/initial { \n   initial-ol-col\n   newpath vertex-lw setlinewidth \n   /vertex-init-radius load 0 360 arc stroke \n} def\n\n");
    }

    private void generateFooter() throws IOException {
        this.out.write("%%EOF\n");
    }

    private void toPostscript(Property property, String color) throws IOException {
        int tail;
        int j = 0;
        int head = 0;
        String line = this.translator.translate(property.getValue().toString());
        int x = (Integer)property.getPropertyValue("x");
        int y = (Integer)property.getPropertyValue("y");
        while (line.substring(head).indexOf("\n") != -1) {
            tail = head + line.substring(head).indexOf("\n");
            this.toPostscriptString(x, -(y + j * 14 + 14), line.substring(head, tail), color);
            ++j;
            head = tail + 1;
        }
        tail = line.length();
        this.toPostscriptString(x, -(y + j * 14 + 14), line.substring(head, tail), color);
    }

    private void toPostscriptString(int x, int y, String line, String color) throws IOException {
        this.out.write("   " + x + " " + y + " moveto " + color + " (");
        block9: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '\r': {
                    this.out.write("\\r");
                    continue block9;
                }
                case '\t': {
                    this.out.write("\\t");
                    continue block9;
                }
                case '\b': {
                    this.out.write("\\b");
                    continue block9;
                }
                case '\f': {
                    this.out.write("\\f");
                    continue block9;
                }
                case '\\': {
                    this.out.write("\\\\");
                    continue block9;
                }
                case '(': {
                    this.out.write("\\(");
                    continue block9;
                }
                case ')': {
                    this.out.write("\\)");
                    continue block9;
                }
                default: {
                    this.out.write(c);
                }
            }
        }
        this.out.write(") show\n");
    }

    private void toSpline(Point2D[] points) throws IOException {
        if (points.length <= 2) {
            this.toPolyLine(points);
            return;
        }
        this.out.write("newpath edge-lw setlinewidth\n");
        this.out.write("   trans-col\n");
        this.out.write("   " + points[0].getX() + " " + -points[0].getY() + "  moveto\n");
        for (int s = 2; s < points.length; ++s) {
            double x0 = points[s - 2].getX();
            double y0 = points[s - 2].getY();
            double x1 = points[s - 1].getX();
            double y1 = points[s - 1].getY();
            double x2 = points[s].getX();
            double y2 = points[s].getY();
            double xd1 = x0 - x1;
            double yd1 = y0 - y1;
            double xd2 = x2 - x1;
            double yd2 = y2 - y1;
            double d1 = Math.sqrt(xd1 * xd1 + yd1 * yd1);
            double d2 = Math.sqrt(xd2 * xd2 + yd2 * yd2);
            if (d2 > 0.0) {
                if (d1 >= 10.0) {
                    xd1 = 10.0 * xd1 / d1;
                    yd1 = 10.0 * yd1 / d1;
                    this.out.write("   " + (x1 + xd1) + " " + -(y1 + yd1) + " lineto\n");
                }
                xd2 = Math.min(d2 / 2.0, 10.0) * xd2 / d2;
                yd2 = Math.min(d2 / 2.0, 10.0) * yd2 / d2;
                this.out.write("   " + x1 + " " + -y1 + " " + x1 + " " + -y1 + " " + (x1 + xd2) + " " + -(y1 + yd2) + " curveto");
                continue;
            }
            this.out.write("   " + x1 + " " + -y1 + " lineto\n");
        }
        this.out.write("   " + points[points.length - 1].getX() + " " + -points[points.length - 1].getY() + "  lineto\n");
        this.out.write("stroke\n");
    }

    private void toPolyLine(Point2D[] points) throws IOException {
        this.out.write("newpath edge-lw setlinewidth\n");
        this.out.write("   trans-col\n");
        for (int segment = 0; segment < points.length; ++segment) {
            this.out.write("   " + points[segment].getX() + " " + -points[segment].getY());
            if (segment == 0) {
                this.out.write("   moveto\n");
                continue;
            }
            this.out.write("   lineto\n");
        }
        this.out.write("stroke\n");
    }

    protected FloatPoint getPos(Element element) {
        int x = (Integer)element.getPropertyValue("x");
        int y = (Integer)element.getPropertyValue("y");
        return new FloatPoint(x, y);
    }

    private void toPostscript(Edge edge) throws IOException {
        FloatPoint lastPos;
        FloatPoint firstPos;
        int length = 2;
        for (Node node = edge.getFirst(); node != null; node = node.getNext()) {
            ++length;
        }
        Point2D[] pathPoints = new FloatPoint[length];
        pathPoints[0] = firstPos = this.getPos(edge.getSource());
        Node node = edge.getFirst();
        int count = 1;
        while (node != null) {
            pathPoints[count] = this.getPos(node);
            node = node.getNext();
            ++count;
        }
        pathPoints[length - 1] = lastPos = this.getPos(edge.getTarget());
        FloatPoint secondPos = pathPoints[1];
        FloatPoint firstUnitVector = secondPos.subtract(firstPos).unitVector();
        FloatPoint newFirstPos = firstPos.add(firstUnitVector.multiply(12.0f));
        FloatPoint secLastPos = pathPoints[length - 2];
        FloatPoint lastUnitVector = lastPos.subtract(secLastPos).unitVector();
        FloatPoint newLastPos = lastPos.subtract(lastUnitVector.multiply(13.0f));
        pathPoints[0] = newFirstPos;
        pathPoints[length - 1] = newLastPos;
        this.toSpline(pathPoints);
        FloatPoint arrowLine = lastUnitVector.multiply(10.0f);
        FloatPoint arrowPoint1 = newLastPos.subtract(arrowLine.rotate(0.2617993877991494));
        FloatPoint arrowPoint2 = newLastPos.subtract(arrowLine.rotate(-0.2617993877991494));
        Point2D[] arrowPoints = new FloatPoint[]{arrowPoint1, newLastPos, arrowPoint2};
        this.toPolyLine(arrowPoints);
    }

    public void visitTemplate(Template template) throws Exception {
        String title = "Template '" + template.getPropertyValue("name").toString() + (this.filename.length() == 0 ? "'." : "' of " + this.filename + ".");
        BoundCalc bc = new BoundCalc();
        template.accept(bc);
        this.generateHeader(title, bc.getBounds());
        this.out.write("% Vertices.\n");
        this.out.write("% Font used for vertex names and invariants.\n");
        this.out.write("/Helvetica-Bold findfont 14 scalefont setfont\n");
        template.accept(new AbstractVisitor(){

            public void visitLocation(Location location) throws Exception {
                PSWriter.this.visitLocation(location);
            }
        });
        this.out.write("\n");
        this.out.write("% Edges.\n");
        this.out.write("% Font used for selects, guards, syncs and assigns.\n");
        this.out.write("/Helvetica findfont 14 scalefont setfont\n");
        template.accept(new AbstractVisitor(){

            public void visitEdge(Edge edge) throws Exception {
                PSWriter.this.visitEdge(edge);
            }
        });
        this.generateFooter();
        this.out.flush();
    }

    public void visitLocation(Location location) throws Exception {
        int x = (Integer)location.getPropertyValue("x");
        int y = (Integer)location.getPropertyValue("y");
        this.out.write(x + " " + -y + " vertex\n");
        if (this.hasFlag(location, "init")) {
            this.out.write("   " + x + " " + -y + " initial\n");
        }
        if (this.hasFlag(location, "committed")) {
            this.out.write("   " + x + " " + -y + " commit\n");
        }
        if (this.hasFlag(location, "urgent")) {
            this.out.write("   " + x + " " + -y + " urgent\n");
        }
        this.toPostscript(location.getProperty("name"), "state-name-col");
        this.toPostscript(location.getProperty("invariant"), "inv-col");
    }

    public void visitEdge(Edge edge) throws Exception {
        this.toPostscript(edge);
        this.toPostscript(edge.getProperty("select"), "select-col");
        this.toPostscript(edge.getProperty("guard"), "guard-col");
        this.toPostscript(edge.getProperty("synchronisation"), "sync-col");
        this.toPostscript(edge.getProperty("assignment"), "assign-col");
    }
}

