/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Visitor;
import java.util.HashMap;

public class Template
extends Node {
    public Template(Element prototype) {
        super(prototype);
    }

    public void accept(Visitor visitor) throws Exception {
        visitor.visitTemplate(this);
    }

    public Location createLocation() {
        return new Location((Element)this.getPropertyValue("#location"));
    }

    public Edge createEdge() {
        return new Edge((Element)this.getPropertyValue("#edge"));
    }

    public Template getTemplate() {
        return this;
    }

    protected Element getPrototypeFromParent(Element parent) {
        return (Element)parent.getPropertyValue("#template");
    }

    public Object clone() throws CloneNotSupportedException {
        Template template = (Template)super.clone();
        final HashMap<Node, Node> mapping = new HashMap<Node, Node>();
        Node p = this.first;
        Node q = template.first;
        while (p != null) {
            assert (q != null);
            mapping.put(p, q);
            p = p.getNext();
            q = q.getNext();
        }
        template.acceptSafe(new AbstractVisitor(){

            public void visitEdge(Edge edge) {
                edge.source = (Location)mapping.get(edge.source);
                edge.target = (Location)mapping.get(edge.target);
            }
        });
        return template;
    }
}

