/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.Parser;
import com.uppaal.engine.Problem;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.model.core2.Document;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.Transition;
import com.uppaal.model.system.UppaalSystem;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineStub {
    public static int LOCAL = 0;
    public static int SERVER = 1;
    public static int BOTH = 2;
    public static String DEFAULT_HOST = "localhost";
    public static int DEFAULT_PORT = 2350;
    private int serverPort;
    private String serverHost;
    private String serverPath;
    private int connectionMode;
    private int connectedPort;
    private Process process;
    private Socket socket;
    private BufferedWriter out;
    private InputStream in;
    private Parser parser;

    public EngineStub() {
        this(LOCAL, DEFAULT_PORT, DEFAULT_HOST, null);
    }

    public EngineStub(int mode, int port, String host, String path) {
        this.connectionMode = mode;
        this.serverPort = port;
        this.serverHost = host;
        this.serverPath = path;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public int getConnectionMode() {
        return this.connectionMode;
    }

    public synchronized void setConnectionMode(int mode) {
        this.connectionMode = mode;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public synchronized void setServerHost(String host) {
        this.serverHost = host;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public int getConnectedPort() {
        return this.connectedPort;
    }

    public synchronized void setServerPath(String path) {
        this.serverPath = path;
    }

    public boolean isConnected() {
        return this.socket != null || this.process != null;
    }

    public boolean isRemoteConnection() {
        return this.socket != null;
    }

    private void setOutputStream(OutputStream out) {
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(out, "utf-8"));
        }
        catch (Exception e) {
            this.out = new BufferedWriter(new OutputStreamWriter(out));
        }
    }

    private void setInputStream(InputStream in) {
        this.in = in;
        this.parser = new Parser(in);
    }

    private void connectLocal() throws EngineException {
        try {
            String[] cmd = new String[]{this.getServerPath()};
            this.process = Runtime.getRuntime().exec(cmd);
            this.setOutputStream(this.process.getOutputStream());
            this.setInputStream(this.process.getInputStream());
        }
        catch (IOException e) {
            throw new EngineException(e.getMessage());
        }
    }

    private void connectRemote() throws EngineException {
        try {
            this.socket = new Socket(this.getServerHost(), this.getServerPort());
            this.connectedPort = this.serverPort;
            this.setOutputStream(this.socket.getOutputStream());
            this.setInputStream(this.socket.getInputStream());
        }
        catch (IOException e) {
            if (this.getConnectionMode() == SERVER) {
                throw new EngineException(e.getMessage());
            }
            this.connectLocal();
        }
    }

    public synchronized void connect() throws EngineException, IOException {
        if (!this.isConnected()) {
            if (this.getConnectionMode() != LOCAL) {
                this.connectRemote();
            } else {
                this.connectLocal();
            }
            this.handshake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        block11: {
            if (!this.isConnected()) {
                return;
            }
            try {
                Object lock;
                this.write("quit");
                this.flush();
                this.connectedPort = -1;
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.socket = null;
                }
                if (this.process == null) break block11;
                Object object = lock = new Object();
                synchronized (object) {
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                EngineStub.this.process.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            Object object = lock;
                            synchronized (object) {
                                lock.notify();
                            }
                        }
                    };
                    t.start();
                    try {
                        lock.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.process.destroy();
                    this.process = null;
                }
            }
            catch (IOException e) {
                this.kill();
            }
        }
    }

    public void kill() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    protected void write(String s) throws IOException {
        this.out.write(s);
        this.out.write(10);
    }

    protected void flush() throws IOException {
        this.out.flush();
    }

    public synchronized void handshake() throws IOException, EngineException {
        this.parser.parseAcknowledgement();
    }

    public synchronized String getVersion() throws IOException, EngineException {
        this.write("version");
        this.flush();
        return this.parser.parseBlock();
    }

    public synchronized String getOptionsInfo() throws EngineException, IOException {
        this.write("getOptionsInfo");
        this.flush();
        return this.parser.parseBlock();
    }

    public synchronized void setOptions(String options) throws EngineException, IOException {
        this.write("setOptions");
        this.write(options);
        this.write(".");
        this.flush();
        this.parser.parseAcknowledgement();
    }

    public synchronized SystemState getInitial(UppaalSystem system) throws EngineException, IOException {
        this.write("getInitialState");
        this.flush();
        return this.parser.parseInitial(system);
    }

    public synchronized Vector<Transition> getTransitions(UppaalSystem system, SystemState state) throws EngineException, IOException {
        this.write("getTransitions");
        this.write(state.toServerFormat());
        this.flush();
        return this.parser.parseEnabledTransitions(system);
    }

    public synchronized UppaalSystem upload(Document document, Vector<Problem> problems) throws EngineException, IOException {
        try {
            this.write("newXMLSystem2");
            document.accept(new XMLWriter(this.out));
            this.write("\n");
            this.write(".");
            this.flush();
            this.parser.parseProblems(problems);
            if (this.parser.parseInteger() == 1) {
                return this.parser.parseSystem(document);
            }
            return null;
        }
        catch (EngineException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineException(e.toString());
        }
    }

    public synchronized UppaalSystem upload(Document document) throws EngineException, IOException {
        try {
            this.write("newXMLSystem2");
            document.accept(new XMLWriter(this.out));
            this.write("\n");
            this.write(".");
            this.flush();
            this.parser.skipProblems();
            if (this.parser.parseInteger() == 1) {
                return this.parser.parseSystem(document);
            }
            return null;
        }
        catch (EngineException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineException(e.toString());
        }
    }

    public synchronized char query(UppaalSystem system, String query, QueryFeedback f) throws EngineException, IOException {
        this.write("modelCheck");
        this.write(query);
        this.write(".");
        this.flush();
        char result = this.parser.parseQueryResult();
        int length = this.parser.parseInteger();
        int cycle = this.parser.parseInteger();
        if (length >= 0) {
            f.setLength(length);
            Vector<Transition> trace = new Vector<Transition>();
            SystemState src = this.parser.parseState(system);
            trace.add(new Transition(null, null, src));
            for (int current = 0; current < length; ++current) {
                SystemEdge[] edges = this.parser.parseEdges(system);
                SystemState dst = this.parser.parseState(system);
                trace.add(new Transition(src, edges, dst));
                src = dst;
                f.setCurrent(current);
            }
            f.setTrace(result, trace, cycle);
            this.parser.parseEnd();
        }
        return result;
    }
}

