/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Template;
import com.uppaal.model.io2.UGIWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class XTAWriter
extends AbstractVisitor {
    protected Map<Element, String> names = new HashMap<Element, String>();
    protected Writer writer;
    protected int level;
    static Pattern endsWithComment = Pattern.compile("(?s:.*)//.*");

    public XTAWriter(OutputStream stream) {
        this.writer = new OutputStreamWriter(stream);
        this.level = 0;
    }

    private void newline(int delta) throws IOException {
        this.level += delta;
        this.writer.write(10);
        for (int i = 0; i < this.level; ++i) {
            this.writer.write("    ");
        }
    }

    public UGIWriter createUGIWriter(OutputStream stream) {
        return new UGIWriter(stream, this.names);
    }

    protected boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    protected boolean hasFlag(Element element, String property) {
        Object value = element.getPropertyValue(property);
        return value != null && (Boolean)value != false;
    }

    protected void writeNonEmptyProperty(Element element, String name, String format) throws IOException {
        String value = (String)element.getPropertyValue(name);
        if (!this.isEmpty(value)) {
            if (endsWithComment.matcher(value).matches()) {
                value = value + '\n';
            }
            this.writer.write(MessageFormat.format(format, value));
        }
    }

    protected void writeNonEmptyProperty(Element element, String name) throws IOException {
        this.writeNonEmptyProperty(element, name, "{0}");
    }

    @Override
    public void visitDocument(Document document) throws Exception {
        document.accept(new AbstractVisitor(){

            protected void collect(Element element) {
                String name = (String)element.getPropertyValue("name");
                if (!XTAWriter.this.isEmpty(name)) {
                    XTAWriter.this.names.put(element, name);
                }
            }

            @Override
            public void visitLocation(Location location) throws Exception {
                this.collect(location);
            }

            @Override
            public void visitTemplate(Template template) throws Exception {
                this.collect(template);
                super.visitTemplate(template);
            }
        });
        document.accept(new AbstractVisitor(){
            protected int counter;
            protected Map<Element, String> localNames;

            @Override
            public void visitLocation(Location location) throws Exception {
                String name = (String)location.getPropertyValue("name");
                if (XTAWriter.this.isEmpty(name)) {
                    while (this.localNames.containsValue(name = "S" + this.counter++)) {
                    }
                    this.localNames.put(location, name);
                }
            }

            @Override
            public void visitTemplate(Template template) throws Exception {
                this.localNames = new HashMap<Element, String>();
                this.counter = 0;
                super.visitTemplate(template);
                XTAWriter.this.names.putAll(this.localNames);
            }
        });
        this.writeNonEmptyProperty(document, "declaration");
        this.newline(0);
        super.visitDocument(document);
        this.writer.write(document.getPropertyValue("system").toString());
        this.writer.flush();
    }

    @Override
    public void visitTemplate(Template template) throws Exception {
        this.newline(0);
        this.writer.write("process ");
        this.writer.write(this.names.get(template));
        this.writer.write("(");
        this.writeNonEmptyProperty(template, "parameter");
        this.writer.write(") {");
        this.newline(0);
        this.writeNonEmptyProperty(template, "declaration");
        this.newline(0);
        this.writer.write("state");
        this.newline(1);
        template.accept(new AbstractVisitor(){
            protected boolean first = true;

            @Override
            public void visitLocation(Location location) throws Exception {
                String comments;
                if (this.first) {
                    this.first = false;
                } else {
                    XTAWriter.this.writer.write(",");
                    XTAWriter.this.newline(0);
                }
                if (location.isPropertyLocal("comments") && (comments = location.getPropertyValue("comments").toString().trim()).length() > 0) {
                    XTAWriter.this.writer.write("/** ");
                    XTAWriter.this.writer.write(comments);
                    XTAWriter.this.writer.write(" */");
                    XTAWriter.this.newline(0);
                }
                XTAWriter.this.writer.write(XTAWriter.this.names.get(location));
                XTAWriter.this.writeNonEmptyProperty(location, "invariant", " '{'{0}'}'");
            }
        });
        this.writer.write(";");
        this.newline(-1);
        template.accept(new StateFlagGenerator("committed", "commit"));
        template.accept(new StateFlagGenerator("urgent", "urgent"));
        template.accept(new AbstractVisitor(){

            @Override
            public void visitLocation(Location location) throws Exception {
                if (XTAWriter.this.hasFlag(location, "init")) {
                    XTAWriter.this.writer.write("init ");
                    XTAWriter.this.writer.write(XTAWriter.this.names.get(location));
                    XTAWriter.this.writer.write(";");
                    XTAWriter.this.newline(0);
                }
            }
        });
        template.accept(new AbstractVisitor(){
            protected boolean first = true;

            @Override
            public void visitTemplate(Template template) throws Exception {
                super.visitTemplate(template);
                if (!this.first) {
                    XTAWriter.this.writer.write(";");
                    XTAWriter.this.newline(-1);
                }
            }

            @Override
            public void visitEdge(Edge edge) throws Exception {
                String comments;
                if (this.first) {
                    this.first = false;
                    XTAWriter.this.writer.write("trans");
                    XTAWriter.this.newline(1);
                } else {
                    XTAWriter.this.writer.write(",");
                    XTAWriter.this.newline(0);
                }
                if (edge.isPropertyLocal("comments") && (comments = edge.getPropertyValue("comments").toString().trim()).length() > 0) {
                    XTAWriter.this.writer.write("/** ");
                    XTAWriter.this.writer.write(comments);
                    XTAWriter.this.writer.write(" */");
                    XTAWriter.this.newline(0);
                }
                XTAWriter.this.writer.write(XTAWriter.this.names.get(edge.getSource()));
                if (edge.hasFlag("controllable")) {
                    XTAWriter.this.writer.write(" -> ");
                } else {
                    XTAWriter.this.writer.write(" -u-> ");
                }
                XTAWriter.this.writer.write(XTAWriter.this.names.get(edge.getTarget()));
                XTAWriter.this.writer.write(" { ");
                XTAWriter.this.writeNonEmptyProperty(edge, "select", "select {0}; ");
                XTAWriter.this.writeNonEmptyProperty(edge, "guard", "guard {0}; ");
                XTAWriter.this.writeNonEmptyProperty(edge, "synchronisation", "sync {0}; ");
                XTAWriter.this.writeNonEmptyProperty(edge, "assignment", "assign {0}; ");
                XTAWriter.this.writer.write(" }");
            }
        });
        this.writer.write("}");
        this.newline(0);
    }

    class StateFlagGenerator
    extends AbstractVisitor {
        protected boolean first = true;
        protected String property;
        protected String flag;

        StateFlagGenerator(String property, String flag) {
            this.property = property;
            this.flag = flag;
        }

        @Override
        public void visitTemplate(Template template) throws Exception {
            super.visitTemplate(template);
            if (!this.first) {
                XTAWriter.this.writer.write(";");
                XTAWriter.this.newline(-1);
            }
        }

        @Override
        public void visitLocation(Location location) throws Exception {
            if (XTAWriter.this.hasFlag(location, this.property)) {
                if (this.first) {
                    this.first = false;
                    XTAWriter.this.writer.write(this.flag);
                    XTAWriter.this.newline(1);
                } else {
                    XTAWriter.this.writer.write(",");
                    XTAWriter.this.newline(0);
                }
                XTAWriter.this.writer.write(XTAWriter.this.names.get(location));
            }
        }
    }
}

