/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.converters;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.swixml.Converter;
import org.swixml.Localizer;
import org.swixml.converters.PrimitiveConverter;
import org.swixml.converters.Util;

public class LayoutConverter
implements Converter {
    public static final Class TEMPLATE = LayoutManager.class;
    public static final String FLOW_LAYOUT = "flowlayout";
    public static final String BORDER_LAYOUT = "borderlayout";
    public static final String GRID_LAYOUT = "gridlayout";
    public static final String GRIDBAG_LAYOUT = "gridbaglayout";
    public static final String CARD_LAYOUT = "cardlayout";

    public Object convert(Class clazz, Attribute attribute, Localizer localizer) {
        LayoutManager layoutManager = null;
        StringTokenizer stringTokenizer = new StringTokenizer(attribute.getValue(), "(,)");
        String string = stringTokenizer.nextToken().trim();
        if (string != null) {
            if ((string = string.toLowerCase()).equals(FLOW_LAYOUT)) {
                try {
                    if (stringTokenizer.hasMoreTokens()) {
                        Object object = PrimitiveConverter.conv(null, new Attribute("NA", stringTokenizer.nextToken()), localizer);
                        int[] nArray = Util.ia(stringTokenizer);
                        layoutManager = nArray.length < 2 ? new FlowLayout(Integer.valueOf(object.toString())) : new FlowLayout(Integer.valueOf(object.toString()), nArray[0], nArray[1]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (layoutManager == null) {
                    layoutManager = new FlowLayout();
                }
            } else if (string.equals(BORDER_LAYOUT)) {
                int[] nArray = Util.ia(stringTokenizer);
                layoutManager = nArray.length < 2 ? new BorderLayout() : new BorderLayout(nArray[0], nArray[1]);
            } else if (string.equals(GRID_LAYOUT)) {
                int[] nArray = Util.ia(stringTokenizer);
                layoutManager = 4 <= nArray.length ? new GridLayout(nArray[0], nArray[1], nArray[2], nArray[3]) : (2 <= nArray.length ? new GridLayout(nArray[0], nArray[1]) : new GridLayout());
            } else if (string.equals(CARD_LAYOUT)) {
                int[] nArray = Util.ia(stringTokenizer);
                layoutManager = nArray.length < 2 ? new CardLayout() : new CardLayout(nArray[0], nArray[1]);
            } else if (string.equals(GRIDBAG_LAYOUT)) {
                layoutManager = new GridBagLayout();
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        String string2 = stringTokenizer.nextToken();
                        Field field = GridBagLayout.class.getField(string2);
                        if (field != null) {
                            Class<?> clazz2 = field.getType();
                            if (int[].class.equals(clazz2)) {
                                field.set(layoutManager, Util.ia(stringTokenizer));
                            } else if (double[].class.equals(clazz2)) {
                                field.set(layoutManager, Util.da(stringTokenizer));
                            }
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }
        return layoutManager;
    }

    public Class convertsTo() {
        return TEMPLATE;
    }
}

