/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemState;

public class Transition {
    private SystemEdge[] edges;
    private SystemState source;
    private SystemState target;
    private static final String PROTOCOL_ERROR = "While reading transition";

    public Transition(SystemState source, SystemEdge[] edges, SystemState target) {
        this.source = source;
        this.edges = edges;
        this.target = target;
    }

    public String traceFormat() {
        StringBuffer s = new StringBuffer("(");
        boolean start = true;
        for (SystemEdge edge : this.edges) {
            if (start) {
                start = false;
            } else {
                s.append(", ");
            }
            s.append(edge.getFormatedName());
        }
        s.append(')');
        return s.toString();
    }

    public String toServerFormat() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.edges.length);
        for (SystemEdge edge : this.edges) {
            buf.append('\n');
            buf.append(edge.getProcess().getIndex()).append('\n');
            buf.append(edge.getIndex() + 1);
        }
        return buf.toString();
    }

    public String toXTRFormat() {
        StringBuffer sb = new StringBuffer();
        for (SystemEdge edge : this.edges) {
            sb.append(edge.getProcess().getIndex()).append(' ');
            sb.append(edge.getIndex() + 1).append('\n');
        }
        sb.append(".\n");
        return sb.toString();
    }

    public SystemState getSource() {
        return this.source;
    }

    public SystemState getTarget() {
        return this.target;
    }

    public SystemEdge[] getEdges() {
        return this.edges;
    }

    public SystemEdge getEdge(int i) {
        return this.edges[i];
    }

    public int getSize() {
        return this.edges.length;
    }

    public boolean involvesProcess(int process) {
        for (SystemEdge edge : this.edges) {
            if (edge.getProcess().getIndex() != process) continue;
            return true;
        }
        return false;
    }

    public String getEdgeDescription() {
        if (this.edges.length > 1) {
            StringBuffer s = new StringBuffer();
            String channel = this.edges[0].getName();
            s.append(channel.substring(0, channel.length() - 1));
            s.append(": ");
            s.append(this.edges[0].getProcessName());
            s.append(" --> ");
            s.append(this.edges[1].getProcessName());
            for (int i = 2; i < this.edges.length; ++i) {
                s.append(", ");
                s.append(this.edges[i].getProcessName());
            }
            return s.toString();
        }
        if (this.edges.length > 0) {
            return this.edges[0].getProcessName();
        }
        return "deadlock";
    }
}

